package org.itscool.commons.document;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * JavaBeansIuWFNgwlkhLgɓWJ邽߂̃NXł
 * @version 1.00A 2006/08/23 VK쐬
 * @author kano
 *
 */
public class BeanToXmlDocument extends XmlDocument{
    
    /**
     * [gurootNamevŎw肵VDocumentCX^X
     * 쐬܂
     * @param rootName ̃hLg̃[gvf̖O
     * @throws Exception
     */
    public BeanToXmlDocument(String rootName) throws Exception{
        super(rootName);
    }
    
    /**
     * w肳ꂽDocumentCX^Xg܂
     * @param document DocumentCX^X
     * @throws Exception
     */
    public BeanToXmlDocument(Document document) throws Exception{
        super(document);
    }
    
    /**
     * w肳ꂽIuWFNghLgɒǉ܂
     * @param bean hLgɒǉIuWFNg
     * @param elementName IuWFNg̗vfiNULLw肵ꍇ
     * NXZbg܂j
     * @throws Exception
     */
    public void addElement(Object bean, String elementName) throws Exception{
        DocumentBean pBean = DocumentBeanParser.parseBean(bean);
        if( elementName != null ){
            pBean.setName(elementName);
        }
        addElement(pBean);
    }
    
    /**
     * w肳ꂽIuWFNghLgɒǉ܂<BR>
     * vf̓IuWFNg̃NXZbg܂
     * @param bean hLgɒǉIuWFNg
     * @throws Exception
     */
    public void addElement(Object bean) throws Exception{
        DocumentBean pBean = DocumentBeanParser.parseBean(bean);
        addElement(pBean);
    }
    
    /**
     * Objectzɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param objects hLgɒǉObjectz
     * @param elementName IuWFNg̗vf
     * @throws Exception
     */
    public void addElement(Object[] objects, String elementName) throws Exception{
        for( int i=0; i<objects.length; i++){
            Object bean = objects[i];
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            if( elementName != null ){
                pBean.setName(elementName);
            }
            addElement(pBean);
        }
    }
    
    /**
     * Objectzɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param objects hLgɒǉObjectz
     * @throws Exception
     */
    public void addElement(Object[] objects) throws Exception{
        for( int i=0; i<objects.length; i++){
            Object bean = objects[i];
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            addElement(pBean);
        }
    }
    
    /**
     * ListCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param list hLgɒǉListCX^X
     * @param elementName IuWFNg̗vf
     * @throws Exception
     */
    public void addElement(List list, String elementName) throws Exception{
        for( int i=0; i<list.size(); i++){
            Object bean = list.get(i);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            if( elementName != null ){
                pBean.setName(elementName);
            }
            addElement(pBean);
        }
    }
    
    /**
     * ListCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param list hLgɒǉListCX^X
     * @throws Exception
     */
    public void addElement(List list) throws Exception{
        for( int i=0; i<list.size(); i++){
            Object bean = list.get(i);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            addElement(pBean);
        }
    }
    
    /**
     * MapCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param map hLgɒǉMapCX^X
     * @param elementName IuWFNg̗vf
     * @throws Exception
     */
    public void addElement(Map map, String elementName) throws Exception{
        Set set = map.keySet();
        Iterator it = set.iterator();
        while( it.hasNext()){
            Object key = it.next();
            Object bean = map.get(key);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            if( elementName != null ){
                pBean.setName(elementName);
            }
            addElement(pBean);
        }
    }
    
    /**
     * MapCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param map hLgɒǉMapCX^X
     * @throws Exception
     */
    public void addElement(Map map) throws Exception{
        Set set = map.keySet();
        Iterator it = set.iterator();
        while( it.hasNext()){
            Object key = it.next();
            Object bean = map.get(key);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            addElement(pBean);
        }
    }
    
    /**
     * JavaBeansWJIuWFNghLgɒǉ܂
     * @param pBean hLgɒǉParseBeanCX^X
     * @throws Exception
     */
    protected void addElement(DocumentBean pBean) throws Exception{
        Element root = document.getDocumentElement();
        Element beanElement = document.createElement(pBean.getName());
        Set set = pBean.keySet();
        Iterator it = set.iterator();
        while(it.hasNext()){
            String name = (String)it.next();
            Object object = pBean.getValue(name);
            if(object instanceof DocumentBean){
                Element element = document.createElement(name);
                addChild((DocumentBean)object, element);
                beanElement.appendChild(element);
            }else{
                String value = (String)pBean.getValue(name);
                Element element = document.createElement(name);
                element.appendChild(document.createTextNode(value));
                beanElement.appendChild(element);
            }
        }
        root.appendChild(beanElement);
    }
    
    /**
     * ElementCX^XɎqDocumentBeanCX^Xǉ܂
     * @param pBean qDocumentBeanCX^X
     * @param element eElementCX^X
     * @throws Exception
     */
    protected void addChild(DocumentBean pBean, Element element) throws Exception{
        Set set = pBean.keySet();
        Iterator it = set.iterator();
        while(it.hasNext()){
            String name = (String)it.next();
            Object object = pBean.getValue(name);
            if(object instanceof DocumentBean){
                Element magoChild = document.createElement(name);
                addChild((DocumentBean)object, magoChild);
                element.appendChild(magoChild);
            }else{
                String value = (String)pBean.getValue(name);
                Element child = document.createElement(name);
                child.appendChild(document.createTextNode(value));
                element.appendChild(child);
            }
        }
        
    }
}



