package org.itscool.stylist.controller;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.collection.InitParamMap;
import org.itscool.commons.util.FileUtil;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.io.HtmlConfigReader;
import org.itscool.stylist.io.HtmlConverter;
import org.itscool.stylist.tag.HtmlRootTag;
import org.itscool.stylist.el.LayoutRegex;

/**
 * XHTML͂AsʂXHTML`ŏo͂NXł<br/>
 * StylistƎ̍\}邱ƂɂAIȉʕ\\ł<br/>
 * ܂x[XXHTML`ł邽߁AAjaxRSSƂ̘AgJSPV[X
 * sƂł܂B<br/>
 *
 * @author kano
 * @version 1.00A 2006/08/09 VK쐬
 */
public class HtmlLayoutServlet4x extends HtmlLayoutServlet{
    /**
     * doGet()AdoPost()\bh̏s܂<br>
     * @param req HttpNGXgCX^X
     * @param res HttpX|XCX^X
     */
    protected void process(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException {
        String path = context.getRealPath(req.getServletPath());
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        
        String encode = params.getParam("encoding");
        if(encode == null){
            log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        HtmlRootTag html = (HtmlRootTag)cacheMap.get(path);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        //LbV݂Ȃ邢̓LbV̍XVtÂꍇ
        if( html == null || html.getLastModified()!=FileUtil.getLastModified(path)){
            html = new HtmlRootTag(encode);
            reader.create(path, html);
            cacheMap.put(path, html);
            log.trace("HtmlTag instance is created");
        }else{
            log.trace("HtmlTag instance geted from chache");
        }
        log.trace(html.toString(0, ""));
        String convStr;
        
        HtmlConverter converter = new HtmlConverter();
        converter.init(context, req);
        convStr = html.getXml()+System.getProperty("line.separator");
        convStr += html.getDtd()+System.getProperty("line.separator");
        convStr += converter.convert(html);
        //JSP1.2EL(ȈՔ)g߂̏ǉ
        convStr = new String(convStr);
        LayoutRegex regex = new LayoutRegex(context, req);
        //./Ŏn܂pXWebAvP[V̘_pXɕϊ
        convStr = regex.replacePath(convStr);
//delete 2007/03/19 kano start HtmlTextConverterɂď
////add 2007/03/17 kano start
//        //FunctionWJ
//        String orgPkg = params.getParam("pkgName");
//        convStr = regex.replaceFunction(orgPkg, convStr);
////add 2007/03/17 kano end
//        //ELWJ
//        convStr = regex.replaceEl(convStr);
//delete 2007/03/19 kano end HtmlTextConverterɂď

        //CAEg擾
        String servletPath = req.getServletPath();
        String layoutPath = layout(servletPath, req);
        if( layoutPath != null ){
            //HTMLHEADBODYɓWJ
            TagInfo body = TagUtil.createTagInfo(convStr, TagInfo.BODY_NAME);
            TagInfo head = TagUtil.createTagInfo(convStr, TagInfo.HEAD_NAME);
            if( body != null ){
                //BODY̏o
                req.setAttribute(Globals.REQ_PARAM_INCLUDE_BODY,
                    body.getDataInTag());
                if(head != null ){
                    //HEADvfLq̏óiCAEgŐU蕪j
                    req.setAttribute(Globals.REQ_PARAM_INCLUDE_HEAD,
                        head.getDataInTag());
                }
            }else{
                req.setAttribute(Globals.REQ_PARAM_INCLUDE_BODY, convStr);
            }

            //CAEg͂܂
            String contextPath = req.getServerName();
            int port = req.getServerPort();
//            String layoutPath = context.getRealPath(layoutName);
            HtmlRootTag layoutTag = new HtmlRootTag(encode);
            HtmlConfigReader layoutReader = new HtmlConfigReader();
            layoutReader.setDefaultEncode(encode);
            layoutReader.create(layoutPath, layoutTag);
            convStr = converter.convert(layoutTag);
            if( body != null ){
                //CAEgvfbodyvfCRecbodyvfɒu
                String bodyTagStr = body.getStartTag();
                Pattern pattern = Pattern.compile("<body>");
                Matcher matcher = pattern.matcher(convStr);
                convStr = matcher.replaceAll(body.getStartTag());
            }
        }

        if( !res.isCommitted() ){
            res.reset();
            //IE6Ń[JHTML̃NbL[ێȂۂւ̑Ή
            initSessionTimeout(req, res);
        }
        
        //ContentTypeݒ
        res.setContentType("text/html; charset=" + encode);
        
        //HTML̉͌ʂo
        PrintWriter writer = res.getWriter();
        writer.write(convStr);
        writer.flush();
        writer.close();
    }
    
    /**
     * CAEg擾܂
     * @param path NCAgvꂽNGXgURI
     * @param req HttpServletRequestCX^X
     * @return CN[h܂ރtH[hJSP
     */
    protected String layout(String path, HttpServletRequest req)
    throws IOException, ServletException{
        String reqPath = context.getRealPath(req.getServletPath());
        RequestDispatcher dispatch = new RequestDispatcher(reqPath);
        String layoutPath = dispatch.getTemplatePath(RequestDispatcher.LAYOUT);
        if( layoutPath == null ){
            log.trace("[NOT FOUND LAYOUT(" + reqPath + ")]");
            String layoutName =  super.layout(path, req);
            layoutPath = context.getRealPath(layoutName);
            return layoutPath;
        }
        log.trace("[FOUND LAYOUT(" + reqPath + ")]"+layoutPath);
        
        //Recp[X܂
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        if(encode == null){
            log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        
        HtmlRootTag layoutTag = (HtmlRootTag)cacheMap.get(layoutPath);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        if( layoutTag == null || layoutTag.getLastModified()!=FileUtil.getLastModified(layoutPath)){
            layoutTag = new HtmlRootTag(encode);
            File file = new File(layoutPath);
            if( !file.isFile()){
                throw new RequestDispatchException("ev[gt@C[" + layoutPath + "]܂ł");
            }
            reader.create(layoutPath, layoutTag);
            log.trace(layoutTag.toString(0, ""));
            cacheMap.put(layoutPath, layoutTag);
            log.trace("HtmlTag(layout) instance is created");
        }else{
            log.trace("HtmlTag(layout) instance geted from chache");
        }
        
        Object[] templates = dispatch.parseLayoutTag(layoutTag);
        for(int i=0; i<templates.length; i++ ){
            String template = (String)templates[i];
            if( template.equals("body") || template.equals("head")){
                continue;
            }
            setIncludeContents(dispatch, template, req);
        }
        
        return layoutPath;
    }
    
    /**
     * CAEg񂩂畔Rec擾ANGXgp[^
     * ɃZbg܂
     * @param dispatch NGXg
     * @param attrName CAEg킷j[NȖO
     * @param req HttpServletRequest
     * @throws IOException
     */
    protected void setIncludeContents(RequestDispatcher dispatch,
        String attrName, HttpServletRequest req)
        throws IOException{
        String layoutPath = dispatch.getTemplatePath(attrName);
        if( layoutPath == null ){
//            throw new RequestDispatchException("[" + attrName +"]ɑΉev[gt@C܂ł");
            req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, "[NOTFOUND LAYOUT PARTS FILE" + attrName + "]"+layoutPath);
            log.trace("[NOTFOUND LAYOUT" + attrName + "]"+layoutPath);
            return;
        }
        log.trace("[FOUND LAYOUT " + attrName + "]"+layoutPath);
        
        //Rec񂪊i[ĂpX擾
        String contextPath = req.getServerName();
        int port = req.getServerPort();
//        String layoutPath = context.getRealPath(layoutName);
        
        //Recp[X܂
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        if(encode == null){
            log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        
        HtmlRootTag layoutTag = (HtmlRootTag)cacheMap.get(layoutPath);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        if( layoutTag == null || layoutTag.getLastModified()!=FileUtil.getLastModified(layoutPath)){
            layoutTag = new HtmlRootTag(encode);
            File file = new File(layoutPath);
            if( !file.isFile()){
                throw new RequestDispatchException("ev[gt@C[" + layoutPath + "]@[" + attrName +"]܂ł");
            }
            reader.create(layoutPath, layoutTag);
            cacheMap.put(layoutPath, layoutTag);
            log.trace("HtmlTag(layout) instance is created");
        }else{
            log.trace("HtmlTag(layout) instance geted from chache");
        }
        
        HtmlConverter converter = new HtmlConverter();
        converter.init(context, req);
        String convStr = converter.convert(layoutTag);
        LayoutRegex regex = new LayoutRegex(context, req);
        //./Ŏn܂pXWebAvP[V̘_pXɕϊ
        //ł΂̕ϊConverterɈϏ
        convStr = regex.replacePath(convStr);
//delete 2007/03/19 kano start HtmlTextConverterɂď
////add 2007/03/17 kano start
//        //FunctionWJ
//        String orgPkg = params.getParam("pkgName");
//        convStr = regex.replaceFunction(orgPkg, convStr);
////add 2007/03/17 kano end
//        //ELWJ
//        convStr = regex.replaceEl(convStr);
//delete 2007/03/19 kano end HtmlTextConverterɂď

        //ELWJ
        convStr = regex.replaceEl(convStr);
        
        TagInfo body = TagUtil.createTagInfo(convStr, TagInfo.BODY_NAME);
        if( body != null ){
            //BODY̏o
            req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, body.getDataInTag());
        }else{
            req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, convStr);
        }
    }
    
}


