package org.itscool.stylist.el;

import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.util.ServletTagUtil;

/**
 * ELWJNXł
 */
public class LayoutRegex extends BaseElRegex{
    private ServletContext context;
    private HttpServletRequest req;
    
    public LayoutRegex(ServletContext context, HttpServletRequest req){
        this.context = context;
        this.req = req;
    }
    
    /**
     * 擪"./"Ŏn܂pXɃT[ubg̃ReLXgpX
     * u܂B
     * @param dstStr ϊƂ̃pX
     * @return T[ubg̃ReLXgpXtʂԂ܂
     */
    public String replacePath(String dstStr){
        String replace = "\""+req.getContextPath() + "/";
        StringBuffer sb = parsePath(dstStr, replace);
        return sb.toString();
    }

    /**
     * ELɋLqꂽɎw肳ꂽIuWFNg擾܂
     * @param elems WJXg
     * @return 擾ꂽIuWFNg
     */
    protected String getAttribute(ElementList elems) throws BeanUtilRuntimeException {
        int size = elems.size();
        String name = elems.getElement(0);
        if( size > 1 ){
            String property = elems.getElement(1);
            Object obj = ServletTagUtil.findProperty(context, req, name, property, null);
            if( size > 2 ){
                for( int i=2; i<size; i++ ){
                    property = elems.getElement(i);
                    if( obj == null || obj.toString().length() == 0 ){
                        return "";
                    }
                    try{
                        obj = BeanUtil.getProperty(obj, property);
                    }catch(Exception e ){
                        throw new ElRegexException("BeanUtil getProperty failed ElementList="+elems.toString());
                    }
                }
            }
            if( obj != null){
                return obj.toString();
            }else{
                return null;
            }
        }else{
            Object obj = ServletTagUtil.findObject(context, req, name, null);
            if( obj != null){
                return obj.toString();
            }else{
                return null;
            }
        }
    }
    
}

