package org.itscool.stylist.io;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.itscool.commons.util.ServletTagUtil;
import org.itscool.stylist.tag.HtmlAttribute;
import org.itscool.stylist.tag.HtmlTag;

/**
 * XHTMLɊ܂܂r()^Of[^ɕϊ܂
 * @author kano
 * @version 1.00A 2006/08/09 VK쐬
 */
public class HtmlCompareTagConverter extends HtmlConverter {
//    /**
//     * CX^X̏s܂
//     * @param context ServletContextCX^X
//     * @param req HttpServletRequestCX^X
//     */
//    public HtmlCompareTagConverter(ServletContext context,
//        HttpServletRequest req) {
//        super(context, req);
//    }
    
    /**
     * pXHTMLf[^̍쐬Jn܂
     * @param node HtmlTagCX^X
     * @return f[^
     */
    public String convert(HtmlTag node, String tab) {
        String tagName = node.getTagName();
        StringBuffer sb = new StringBuffer();
        
        String name = node.getAttribute(HtmlAttribute.W_NAME);
        String property = node.getAttribute(HtmlAttribute.W_PROPERTY);
        String value = node.getAttribute(HtmlAttribute.W_VALUE);
        String scope = node.getAttribute(HtmlAttribute.W_SCOPE);
        
        Object obj1 = ServletTagUtil.findProperty(context, req, name, property, scope);
        Object obj2 = ServletTagUtil.findValue(context, req, value, scope);
        
        if( !compare(node.getTagKind(), obj1, obj2) ){
            return "";
        }
        int size = node.size();
        for(int i=0; i<size; i++ ){
            HtmlTag child = (HtmlTag)node.get(i);
            sb.append(super.convert(child, tab + "  "));
        }
        sb.append(LINE);
        return sb.toString();
    }
    
    /**
     * r^O̎ނɉăIuWFNgm̔rs܂
     * @param tagKind r^O̎
     * @param obj1 rΏۃIuWFNgP
     * @param obj2 rΏۃIuWFNgQ
     * @return rʂv̏ꍇtrueԂ܂
     */
    public boolean compare(String tagKind, Object obj1, Object obj2){
        boolean ret = false;
        String value1 = "";
        String value2 = "";
        if( obj1 != null ){
            value1 = obj1.toString();
        }
        if( obj2 != null){
            value2 = obj2.toString();
        }
        try{
            if( tagKind.equals(HtmlTag.KIND_EQUAL)){
                Double dValue1 = Double.valueOf(value1);
                Double dValue2 = Double.valueOf(value2);
                if( dValue1.doubleValue() == dValue2.doubleValue() ){
                    ret = true;
                }
            } else if( tagKind.equals(HtmlTag.KIND_MOREEQUAL)){
                Double dValue1 = Double.valueOf(value1);
                Double dValue2 = Double.valueOf(value2);
                if( dValue1.doubleValue() >= dValue2.doubleValue() ){
                    ret = true;
                }
            } else if( tagKind.equals(HtmlTag.KIND_LESSEQUAL)){
                Double dValue1 = Double.valueOf(value1);
                Double dValue2 = Double.valueOf(value2);
                if( dValue1.doubleValue() <= dValue2.doubleValue() ){
                    ret = true;
                }
            } else if( tagKind.equals(HtmlTag.KIND_MORETHAN)){
                Double dValue1 = Double.valueOf(value1);
                Double dValue2 = Double.valueOf(value2);
                if( dValue1.doubleValue() > dValue2.doubleValue() ){
                    ret = true;
                }
            } else if( tagKind.equals(HtmlTag.KIND_LESSTHAN)){
                Double dValue1 = Double.valueOf(value1);
                Double dValue2 = Double.valueOf(value2);
                if( dValue1.doubleValue() < dValue2.doubleValue() ){
                    ret = true;
                }
            } else if( tagKind.equals(HtmlTag.KIND_NOTEQUAL)
            || tagKind.equals(HtmlTag.KIND_NOMATCH)){
                if( !value1.equals(value2) ){
                    ret = true;
                }
            } else if( tagKind.equals(HtmlTag.KIND_MATCH)){
                if( value1.equals(value2) ){
                    ret = true;
                }
            }
        }catch(Exception e){}
        return ret;
    }
}
