package org.itscool.weber.controller;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.collection.InitParamMap;
import org.itscool.commons.collection.KeyLinkedList;
import org.itscool.commons.dao.EntityInfoMapping;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.weber.action.*;
import org.itscool.weber.mapping.ExceptionMappings4x;

/**
 * scaffoladT[ubgNXł<br>
 * ]FrontServlet@\pANGXgURLANVƃtH[IuWFNg
 * IɌoA܂
 */
public class FrontServlet4x extends FrontServlet{
    
    /**
     * T[ubgƂɌĂ΂܂<br>
     * f[^ݒ肵܂
     * @param factory di-config.xmlt@C珉ݒ擾CX^X
     */
    public void initConfig(BeanFactory factory) throws ServletException {
        ExceptionMappings4x weber2Config = (ExceptionMappings4x)factory.createInstance("ExceptionMappings4x");
        try{
            log = (AbstractLog)factory.getInstance("Log");
            if(!log.isInit()){
                log = (AbstractLog)factory.createInstance("Log");
            }
            try{
                EntityInfoMapping daoMapping = (EntityInfoMapping)factory.createInstance("EntityInfoMapping");
            }catch(Exception ioe){
                log.info("DaoConfigReader͎s܂");
            }
        }catch(Exception ioe){
            log = SimpleLog.getInstance();
            log.info(ioe.getMessage());
        }
    }
    
    /**
     * ƖĂяo܂
     * @param req HttpServletRequestCX^X
     * @param res HttpServletResponseCX^X
     * @return sʂ\URLԂ܂
     */
    protected String invoke(HttpServletRequest req, HttpServletResponse res)
    throws Exception{
        String returnPage = process(req, res);
        return returnPage;
    }
    
    /**
     * NGXgpXActionCX^X擾܂B
     * @param path NGXgpXw肵܂
     * @return ꂽActionCX^X
     */
    public Action getAction(HttpServletRequest req, String path)
    throws IOException {
        ExceptionMappings4x config = (ExceptionMappings4x)ExceptionMappings4x.getInstance();
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
        String pkgName = params.getParam("pkgName");
        String fileType = params.getParam("fileType");
        RequestDispatcher pathInfo = new RequestDispatcher(path);
        String clazzName = pathInfo.getPkgActionName(pkgName);
        
//        System.out.println(clazzName);
        
        Action action = (Action) BeanUtil.createInstance(clazzName);
        
        action.setForwards(null);
        action.setValidates(null);
        
        return action;
    }
    
    /**
     * NGXgpXFormBeanCX^X擾܂B
     * @param path NGXgpXw肵܂
     * @return ꂽFormBeanCX^X
     */
    public Object getForm(String path) throws IOException{
        ExceptionMappings4x config = (ExceptionMappings4x)ExceptionMappings4x.getInstance();
        
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String pkgName = params.getParam("pkgName");
        String fileType = params.getParam("fileType");
        RequestDispatcher pathInfo = new RequestDispatcher(path);
        String clazzName = pathInfo.getFormName(pkgName);
        if( clazzName == null ){
            return null;
        }
//        System.out.println(clazzName);
        
        Object bean=null;
        try{
            bean = (Object) BeanUtil.createInstance(clazzName);
        }catch(Exception e){
            
        }
        return bean;
    }
    
    /**
     * NGXgURIɎw肳ꂽ擾܂<BR>
     * 񂪒`ĂȂ΂NULLԂ܂
     * @param path NGXgꂽURI
     * @return HashMap ̃ANV錠XgԂ܂
     */
    public HashMap getRoles(String path) {
        HashMap roles = new HashMap();
//        RequestMappings config = (RequestMappings)RequestMappings.getInstance();
//        String pkgName = config.getPkgName();
//        String fileType = config.getFileType();
//        RequestDispatcher pathInfo = new RequestDispatcher(path);
//        String moduleName = pathInfo.getModuleName();
//        String actionName = pathInfo.getActionName();
//        Map roleAction = config.getRolesAction();
//
//        Map roleModule = config.getRolesModule();
//        String roleName = (String)roleAction.get(moduleName+actionName);
//        if(roleName == null){
//            roleName = (String)roleModule.get(moduleName);
//        }
//        if(roleName != null){
//            roles.put(roleName, roleName);
//        }
        return roles;
    }
    
    /**
     * Ɩs̑JڐURL擾܂
     * @param action ActionCX^X
     * @param ret Action̎s
     * @param path NGXgpX
     */
    protected String getForward(Action action, String ret, String path) throws ServletException {
        ExceptionMappings4x config = (ExceptionMappings4x)ExceptionMappings4x.getInstance();
        
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String pkgName = params.getParam("pkgName");
        String fileType = params.getParam("fileType");
        if(fileType.indexOf(".")!=0){
            fileType = "." + fileType;
        }
        RequestDispatcher pathInfo = new RequestDispatcher(path);
        String moduleName = pathInfo.getModuleName();
        String actionName = pathInfo.getActionName();
        String returnPath = pathInfo.getReturnPath(ret);
        returnPath += fileType;
        return returnPath;
    }
    
    /**
     * ȎJڐURL擾܂
     * @param e Exception/ErrorCX^X
     * @return ȎJڐURL
     */
    protected String getExceptionPage(Object e){
        ExceptionMappings4x config = (ExceptionMappings4x)ExceptionMappings4x.getInstance();
        KeyLinkedList exceptions = config.getExceptions();
        int size = exceptions.size();
        if( size == 0 ) return null;
        String exceptionName = null;
        for(int i=size-1; i>=0; i--){
            String key = (String)exceptions.getKey(i);
            exceptionName = e.getClass().getName();
            if(key.equals(exceptionName)){
                break;
            }
            else{
                try{
                    Class clazz = Class.forName(key);
                    if(clazz.isInstance(e)){
                        exceptionName = key;
                        break;
                    }
                }catch(Exception ex){}
            }
        }
        if( exceptionName == null )return null;
        String exceptionPage = (String)exceptions.get(exceptionName);
        return exceptionPage;
    }
}

