/*
 * WeberLogicDispatcher.java
 *
 * Created on 2007/01/28, 7:50
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.weber.controller;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.itscool.commons.util.StringUtil;
import org.itscool.weber.action.*;
import org.itscool.weber.user.User;

/**
 * NGXgpXAANVAtH[IuWFNg
 * ANVs̑JڐURL𐶐NXł<br>
 * @author kanou
 */
public class RequestDispatcher {
    /**
     * NGXgpX
     */
    private String fullPath = "";
    /**
     * WebAvP[Ṽ[gfBNgAW[AANV
     * pX
     */
    private String etcPath = "";
    /**
     * W[iNGXgpX̍Ō̃pX)
     */
    private String moduleName = "";
    /**
     * ANVigq)
     */
    private String actionName = "";
    
    /**
     * NGXgURL񂩂烂W[AANV͂܂
     * <br>
     * j Ⴆ΁Aȉ̃NGXgURL擾郂W[AANV
     * <br>
     * http://localhost/web-app-root/web-root/module_name/action_name.wb
     * <br>
     * tH[Bean=ModuleName<br>
     * ANV=ActionNameAction<br>
     * ƂȂ܂
     * @param path NGXgURL
     */
    public RequestDispatcher(String path){
        this.fullPath = path;
        StringTokenizer st = new StringTokenizer(path, "/");
        ArrayList tokens = new ArrayList();
        while(st.hasMoreElements()){
            String element = (String)st.nextElement();
            tokens.add(element);
        }
        int tokenSize = tokens.size();
        
        if(tokenSize < 2){
            //肦ȂP[X
            return;
        }else if( tokenSize == 2){
            moduleName = (String)tokens.get(0);
            actionName = (String)tokens.get(1);
        }else{
            //W[擾
            moduleName = (String)tokens.get(tokenSize-2);
            //ANV擾i̎_ł"."Ă)
            actionName = (String)tokens.get(tokenSize-1);
            //NGXgpX烂W[AANVpX擾
            for(int i=0; i<tokenSize-2; i++){
                etcPath += (String)tokens.get(i) + "/";
            }
        }
        
        if( moduleName.length() == 1 ){
            moduleName = moduleName.toUpperCase();
        }else{
            moduleName = moduleName.substring(0,1).toUpperCase() + 
                moduleName.substring(1, moduleName.length());
        }
        //actionNamegq
        int lastDotPos = actionName.lastIndexOf(".");
        if( lastDotPos >= 1 ){
            if( actionName.length() == 1 ){
                actionName = actionName.toUpperCase();
            }else{
                actionName = actionName.substring(0, lastDotPos);
                //啶ɕϊ
                actionName = actionName.substring(0,1).toUpperCase() + 
                    actionName.substring(1, actionName.length());
            }
        }
        
        moduleName = StringUtil.cnvUnderScorNameToUpperName(moduleName);
        actionName = StringUtil.cnvUnderScorNameToUpperName(actionName);
        
    }
    
    /**
     * pbP[WtANV擾܂
     * @param pkgName pbP[W
     * @return pbP[W.ANVNXԂ܂
     */
    public String getPkgActionName(String pkgName){
        if( (moduleName + actionName).equals("WeberLogin") ){
            return LoginAction.class.getName();
        }else if((moduleName + actionName).equals("WeberLogout")){
            return LogoutAction.class.getName();
        }else if( StringUtil.cnvUpperNameToUnderScoreName(actionName).equals("no_operation")){
            return NoOpAction4x.class.getName();
        }
        String clazzName = pkgName + "." + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "." +
            moduleName + actionName + "Action";
        
        return clazzName;
    }
    
    /**
     * pbP[WttH[IuWFNg擾܂
     * @param pkgName pbP[W
     * @return pbP[W.tH[IuWFNgNXԂ܂
     */
    public String getFormName(String pkgName){
        if( (moduleName + actionName).equals("WeberLogin") ){
            return User.class.getName();
        }else if((moduleName + actionName).equals("WeberLogout")){
            return User.class.getName();
        }else if( actionName.equals("no_operation")){
            return null;
        }
        String clazzName = pkgName + "."+ StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "."
            + moduleName;
        
        return clazzName;
    }
    
    /**
     * W[擾܂
     * @return W[
     */
    public String getModuleName() {
        return moduleName;
    }
    
    /**
     * ANV擾܂
     * @return ANV
     */
    public String getActionName() {
        return actionName;
    }
    
    /**
     * ANV̎sʂJڐURL擾܂<br/>
     * Ƃ΃ANV̎sʂ"regist"AW["message"̏ꍇ
     * JڐURL"NGXg̃pX/message/message_regist.html"
     * Ԃ܂B
     * @param ret ANV̎s
     * @return JڐURL
     */
    public String getReturnPath(String ret){
        String returnName = "";
        String moduleActionName;
        if(ret == null || ret.trim().length() == 0 ){
            returnName = "/" + etcPath + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "/";
            moduleActionName = moduleName + actionName;
            returnName =  returnName + StringUtil.cnvUpperNameToUnderScoreName(moduleActionName);
            return returnName;
        }else if(ret.length()==1){
            ret = ret.toUpperCase();
        }else{
            ret = ret.substring(0,1).toUpperCase() + 
                ret.subSequence(1, ret.length());
        }
        if( ret.toLowerCase().equals(Globals.REQ_PARAM_FORM_ERR)){
            //̓G[͌ďoƂ̃ANVƂ
            returnName = "/" + etcPath + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "/";
            moduleActionName = moduleName + actionName;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName(moduleActionName);
        }else if( (moduleName + actionName).equals("WeberLogin") ){
            returnName = "/" + etcPath + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "/";
            moduleActionName = moduleName + actionName + ret;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName(moduleActionName);
        }else if((moduleName + actionName).equals("WeberLogout")){
            returnName = "/" + etcPath + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "/";
            moduleActionName = moduleName + actionName + ret;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName(moduleActionName);
        }else{
            returnName = "/" + etcPath + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "/";
            moduleActionName = moduleName + ret;
            returnName =  returnName + StringUtil.cnvUpperNameToUnderScoreName(moduleActionName);
        }
        return returnName;
    }
}
