/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao2;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.commons.dao.RecordMapFkFactory;
import org.itscool.commons.util.StringUtil;

public class PreparedStatementWrapper {
    private PreparedStatement pstmt;

    public PreparedStatementWrapper(PreparedStatement pstmt) {
        this.pstmt = pstmt;
    }

    public void setValue(int id, String value) {
        try {
            this.pstmt.setString(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, byte value) {
        try {
            this.pstmt.setByte(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, short value) {
        try {
            this.pstmt.setShort(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, int value) {
        try {
            this.pstmt.setInt(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, long value) {
        try {
            this.pstmt.setLong(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, double value) {
        try {
            this.pstmt.setDouble(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, float value) {
        try {
            this.pstmt.setFloat(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, byte[] value) {
        try {
            this.pstmt.setBytes(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, InputStream value) {
        try {
            this.pstmt.setBinaryStream(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, Blob value) {
        try {
            this.pstmt.setBlob(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, Reader value) {
        try {
            this.pstmt.setCharacterStream(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, java.util.Date value) {
        try {
            Date sqlValue = new Date(value.getTime());
            this.pstmt.setDate(id, sqlValue);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public List select(Class entity) {
        LinkedList<Object> result = new LinkedList<Object>();
        ResultSet rs = null;
        try {
            rs = this.pstmt.executeQuery();
            List recordList = this.createRecordList(rs);
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
            for (int i = 0; i < recordList.size(); ++i) {
                HashMap record = (HashMap)recordList.get(i);
                Object newBean = this.createBean(record, gRecordMap);
                Set keySet = fkRecordMaps.keySet();
                Iterator it = keySet.iterator();
                while (it.hasNext()) {
                    Object fkBean;
                    String fkPropertyName = (String)it.next();
                    RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(fkPropertyName);
                    if (fkRecordMap == null || (fkBean = this.createBean(record, fkRecordMap)) == null) continue;
                    BeanUtil.setProperty(newBean, fkPropertyName, fkBean);
                }
                result.add(newBean);
            }
            LinkedList<Object> linkedList = result;
            return linkedList;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private List createRecordList(ResultSet rs) throws SQLException {
        ArrayList recordList = new ArrayList();
        while (rs.next()) {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            HashMap<String, HashMap<String, Object>> record = new HashMap<String, HashMap<String, Object>>();
            for (int i = 0; i < columnCount; ++i) {
                String colName = metaData.getColumnName(i + 1);
                String colAsName = metaData.getColumnLabel(i + 1);
                String tableName = metaData.getTableName(i + 1);
                Object value = rs.getObject(i + 1);
                HashMap<String, Object> datasOfTable = (HashMap<String, Object>)record.get(tableName);
                if (datasOfTable == null) {
                    datasOfTable = new HashMap<String, Object>();
                    record.put(tableName, datasOfTable);
                }
                datasOfTable.put(colAsName, value);
            }
            recordList.add(record);
        }
        return recordList;
    }

    private Object createBean(HashMap record, RecordMap recordMap) {
        String entityName = recordMap.getClassName();
        String tableName = recordMap.getTableName();
        HashMap datasOfTable = (HashMap)record.get(tableName);
        if (datasOfTable == null) {
            return null;
        }
        Object newBean = BeanUtil.createInstance(entityName);
        Set datasKeySet = datasOfTable.keySet();
        Iterator datasIt = datasKeySet.iterator();
        while (datasIt.hasNext()) {
            String colAsName = (String)datasIt.next();
            Object value = datasOfTable.get(colAsName);
            String propertyName = StringUtil.cnvUnderScorNameToLowerName(colAsName);
            BeanUtil.setProperty(newBean, propertyName, value);
        }
        return newBean;
    }

    public Records select() {
        ResultSet rs = null;
        try {
            rs = this.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            Records records = new Records();
            while (rs.next()) {
                Record record = new Record();
                for (int i = 0; i < columnCount; ++i) {
                    String colName = metaData.getColumnName(i + 1);
                    String colAsName = metaData.getColumnLabel(i + 1);
                    String tableName = metaData.getTableName(i + 1);
                    if (!colAsName.equals("")) {
                        colName = colAsName;
                    }
                    colName = colName.toUpperCase();
                    Object value = rs.getObject(i + 1);
                    String key = tableName + "." + colName;
                    key = key.toUpperCase();
                    record.put(key, value);
                }
                records.add(record);
            }
            Records records2 = records;
            return records2;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public ResultSet executeQuery() {
        try {
            ResultSet ret = this.pstmt.executeQuery();
            return ret;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public int executeUpdate() {
        try {
            int ret = this.pstmt.executeUpdate();
            return ret;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }
}

