/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.action;

import java.util.HashMap;
import java.util.List;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.commons.util.InputCheckUtil;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.action.Validation;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.user.RoleException;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserManager;

public abstract class Action {
    private HashMap lnkForwards;
    private ActionBucket bucket;
    private List validates;
    private GeneralForm generalForm = null;
    private HashMap errList = new HashMap();

    public String getForward(String name) {
        return (String)this.lnkForwards.get(name);
    }

    public void setForwards(HashMap forwards) {
        this.lnkForwards = forwards;
    }

    public void setGeneralForm(GeneralForm generalForm) {
        this.generalForm = generalForm;
    }

    public void init(ActionBucket bucket, GeneralForm generalForm) {
        this.bucket = bucket;
        this.setGeneralForm(generalForm);
    }

    public void setForm(Object bean) {
        this.bucket.setForm(bean);
    }

    public String execute() throws Exception {
        return this.doExecute(this.bucket);
    }

    public String beforeExecute() throws Exception {
        String ret = "success";
        this.beforeCheckRole();
        if (!this.checkRole(this.bucket)) {
            ret = this.doAuthFailure(this.bucket);
            return ret;
        }
        ret = this.validate(this.bucket);
        if (!ret.equals("success")) {
            this.bucket.setRetryInputParam(this.generalForm);
            return ret;
        }
        return ret;
    }

    public void putRole(String roleName) {
        this.bucket.putRole(roleName);
    }

    public void beforeCheckRole() {
    }

    public boolean checkRole(ActionBucket bucket) {
        boolean ret = true;
        if (bucket.getRoles() == null || bucket.getRoles().size() == 0) {
            return true;
        }
        User user = (User)bucket.getAttributeFromSession("org_itscool_weber_action_USER");
        if (user == null) {
            throw new RoleException();
        }
        ret = this.isUserCheck(bucket.getRoles(), user);
        return ret;
    }

    public String validate(ActionBucket bucket) throws Exception {
        Validation validation = Validation.getInstance();
        this.errList = validation.isValidate(this.validates, this.generalForm);
        if (this.isInputError()) {
            bucket.setAttribute("input_error", this.errList);
            return this.doInputFailure(bucket);
        }
        String ret = this.doValidate(bucket);
        if (this.isInputError() || !ret.equals("success")) {
            if (!this.isInputError()) {
                return ret;
            }
            bucket.setAttribute("input_error", this.errList);
            if (ret != null && ret.length() > 0) {
                return ret;
            }
            return this.doInputFailure(bucket);
        }
        return "success";
    }

    public abstract String doExecute(ActionBucket var1) throws Exception;

    protected String doValidate() throws Exception {
        return "success";
    }

    protected String doValidate(ActionBucket bucket) throws Exception {
        return this.doValidate();
    }

    protected String doAuthFailure(ActionBucket bucket) {
        return "org.itscool.weber.action.ROLE_FAIL";
    }

    protected String doInputFailure(ActionBucket bucket) {
        return "input_error";
    }

    public boolean isUserCheck(HashMap roles, User user) {
        boolean ret = false;
        BeanFactory factory = BeanFactory.getInstance();
        UserManager manager = (UserManager)factory.createInstance("UserManager");
        ret = manager.isUserCheck(roles, user);
        if (!ret) {
            throw new RoleException();
        }
        return ret;
    }

    protected void putMessage(Object key, Object msg) {
        this.errList.put(key, msg);
    }

    protected void putMessage(Object key) {
        MessageMappings messages = MessageMappings.getInstance();
        String message = (String)messages.get(key);
        this.putMessage(key, message);
    }

    public boolean isInputError() {
        boolean ret = false;
        if (this.errList.size() > 0) {
            ret = true;
        }
        return ret;
    }

    protected boolean isInt(String paramName) {
        boolean ret = true;
        try {
            Object value = this.getParameter(paramName);
            if (!(value instanceof String)) {
                return false;
            }
            String paramValue = (String)value;
            Integer.parseInt(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isLong(String paramName) {
        boolean ret = true;
        try {
            Object value = this.getParameter(paramName);
            if (!(value instanceof String)) {
                return false;
            }
            String paramValue = (String)value;
            Long.parseLong(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isDouble(String paramName) {
        boolean ret = true;
        try {
            Object value = this.getParameter(paramName);
            if (!(value instanceof String)) {
                return false;
            }
            String paramValue = (String)value;
            Double.parseDouble(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isFloat(String paramName) {
        boolean ret = true;
        try {
            Object value = this.getParameter(paramName);
            if (!(value instanceof String)) {
                return false;
            }
            String paramValue = (String)value;
            Float.parseFloat(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isShort(String paramName) {
        boolean ret = true;
        try {
            Object value = this.getParameter(paramName);
            if (!(value instanceof String)) {
                return false;
            }
            String paramValue = (String)value;
            Short.parseShort(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isNotNull(String paramName) {
        boolean ret = true;
        try {
            Object value = this.getParameter(paramName);
            if (!(value instanceof String)) {
                return false;
            }
            String paramValue = (String)value;
            if (paramValue == null || paramValue.toString().length() == 0) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected Object getParameter(String paramName) {
        Object result = null;
        Object obj = this.generalForm.getParameter(paramName);
        return obj;
    }

    public List getValidates() {
        return this.validates;
    }

    public void setValidates(List validates) {
        this.validates = validates;
    }

    protected boolean isNotNull(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.isNotNull((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.isNotNull((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean isNotNull(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.isNotNull((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.isNotNull((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkFullSize(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkFullSize((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkFullSize((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkFullSize(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkFullSize((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkFullSize((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkHalfSize(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkHalfSize((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkFullSize((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkHalfSize(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkHalfSize((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkHalfSize((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkDigit(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkDigit((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkDigit((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkDigit(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkDigit((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkDigit((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkAlphabet(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkAlphabet((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkAlphabet((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkAlphabet(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkAlphabet((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkAlphabet((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkSmallAlphabet(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkSmallAlphabet((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkSmallAlphabet((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkSmallAlphabet(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkSmallAlphabet((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkSmallAlphabet((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkDigitAlphabet(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkDigitAlphabet((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkDigitAlphabet((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkDigitAlphabet(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkDigitAlphabet((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkDigitAlphabet((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkHankakuKana(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkHankakuKana((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkHankakuKana((String)paramValue);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkHankakuKana(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkHankakuKana((String)oneValue);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkHankakuKana((String)paramValue);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkStrLength(String paramName, int min, int max, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkStrLength((String)oneValue, (int)min, (int)max);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkStrLength((String)paramValue, (int)min, (int)max);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkStrLength(String paramName, int min, int max, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkStrLength((String)oneValue, (int)min, (int)max);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkStrLength((String)paramValue, (int)min, (int)max);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean checkDigitLength(String paramName, int min, int max, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkDigitLength((String)oneValue, (double)min, (double)max);
                if (ret) continue;
                this.putMessage(errCode);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkDigitLength((String)paramValue, (double)min, (double)max);
        if (!ret) {
            this.putMessage(errCode);
        }
        return ret;
    }

    protected boolean checkDigitLength(String paramName, int min, int max, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String oneValue = (String)values.get(i);
                ret = InputCheckUtil.checkDigitLength((String)oneValue, (double)min, (double)max);
                if (ret) continue;
                this.putMessage(errCode, errMsg);
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        ret = InputCheckUtil.checkDigitLength((String)paramValue, (double)min, (double)max);
        if (!ret) {
            this.putMessage(errCode, errMsg);
        }
        return ret;
    }

    protected boolean isDateString(String paramName, String errCode) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            int i = 0;
            List values = (List)value;
            int size = values.size();
            if (i < size) {
                String oneValue = (String)values.get(i);
                String oneFmt = DateFormatUtil.searchDateFormat((String)oneValue);
                if (oneFmt == null) {
                    this.putMessage(errCode);
                    return false;
                }
                return true;
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        String fmt = DateFormatUtil.searchDateFormat((String)paramValue);
        if (fmt == null) {
            this.putMessage(errCode);
            return false;
        }
        return true;
    }

    protected boolean isDateString(String paramName, String errCode, String errMsg) {
        boolean ret = true;
        Object value = this.getParameter(paramName);
        if (value instanceof List) {
            int i = 0;
            List values = (List)value;
            int size = values.size();
            if (i < size) {
                String oneValue = (String)values.get(i);
                String oneFmt = DateFormatUtil.searchDateFormat((String)oneValue);
                if (oneFmt == null) {
                    this.putMessage(errCode, errMsg);
                    return false;
                }
                return true;
            }
            return ret;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String paramValue = (String)value;
        String fmt = DateFormatUtil.searchDateFormat((String)paramValue);
        if (fmt == null) {
            this.putMessage(errCode, errMsg);
            return false;
        }
        return true;
    }
}

