/*
 * BeanUtil5Test.java
 *
 * Created on 2007/03/26, 12:36
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.commons.bean;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.itscool.commons.bean.BeanUtil;

/**
 *
 * @author Kano
 */
public class BeanUtil5Test extends TestCase{
    public void testSetPropertyArray(){
        SampleChild5[] array = new SampleChild5[2];
        array[0] = new SampleChild5("test1");
        array[1] = new SampleChild5("test2");
        SampleBean5 bean = new SampleBean5();
        BeanUtil.setProperty(bean, "objArray", array);
        
        SampleChild5[] chkArray = bean.getObjArray();
        assertEquals("array instance", array, chkArray);
        assertEquals("array[0]", array[0], chkArray[0]);
        assertEquals("array[0].name", array[0].getName(), chkArray[0].getName());
        assertEquals("array[1]", array[1], chkArray[1]);
        assertEquals("array[1].name", array[1].getName(), chkArray[1].getName());
    }
    
    public void testGetPropertyArray(){
        SampleChild5[] array = new SampleChild5[2];
        array[0] = new SampleChild5("test1");
        array[1] = new SampleChild5("test2");
        SampleBean5 bean = new SampleBean5();
        bean.setObjArray(array);
        
        SampleChild5[] chkArray = (SampleChild5[])BeanUtil.getProperty(bean, "objArray");
        assertEquals("array instance", array, chkArray);
        assertEquals("array[0]", array[0], chkArray[0]);
        assertEquals("array[0].name", array[0].getName(), chkArray[0].getName());
        assertEquals("array[1]", array[1], chkArray[1]);
        assertEquals("array[1].name", array[1].getName(), chkArray[1].getName());
    }
    
    public void testSetPropertyArray2(){
        Object[] array = new Object[2];
        array[0] = new SampleChild5("test1");
        array[1] = new SampleChild5("test2");
        SampleBean5 bean = new SampleBean5();
        BeanUtil.setProperty(bean, "objArray2", array);
        
        Object[] chkArray = bean.getObjArray2();
        assertEquals("array instance", array, chkArray);
        assertEquals("array[0]", array[0], chkArray[0]);
        assertEquals("array[0].name", ((SampleChild5)array[0]).getName(),((SampleChild5)chkArray[0]).getName());
        assertEquals("array[1]", array[1], chkArray[1]);
        assertEquals("array[1].name", ((SampleChild5)array[1]).getName(), ((SampleChild5)chkArray[1]).getName());
    }
    
    public void testGetPropertyArray2(){
        Object[] array = new Object[2];
        array[0] = new SampleChild5("test1");
        array[1] = new SampleChild5("test2");
        SampleBean5 bean = new SampleBean5();
        bean.setObjArray2(array);
        
        Object[] chkArray = (Object[])BeanUtil.getProperty(bean, "objArray2");
        assertEquals("array instance", array, chkArray);
        assertEquals("array[0]", array[0], chkArray[0]);
        assertEquals("array[0].name", ((SampleChild5)array[0]).getName(),((SampleChild5)chkArray[0]).getName());
        assertEquals("array[1]", array[1], chkArray[1]);
        assertEquals("array[1].name", ((SampleChild5)array[1]).getName(), ((SampleChild5)chkArray[1]).getName());
    }
    
    public void testSetPropertyArray3(){
        ArrayList array = new ArrayList();
        array.add(new SampleChild5("test1"));
        array.add(new SampleChild5("test2"));
        SampleBean5 bean = new SampleBean5();
        BeanUtil.setProperty(bean, "objArray3", array);
        
        List chkArray = bean.getObjArray3();
        assertEquals("array instance", array, chkArray);
        assertEquals("array[0]", array.get(0), chkArray.get(0));
    }
    
    public void testGetPropertyArray3(){
        ArrayList array = new ArrayList();
        array.add(new SampleChild5("test1"));
        array.add(new SampleChild5("test2"));
        SampleBean5 bean = new SampleBean5();
        bean.setObjArray3(array);
        
        List chkArray = (List)BeanUtil.getProperty(bean, "objArray3");
        assertEquals("array instance", array, chkArray);
        assertEquals("array[0]", array.get(0), chkArray.get(0));
    }
}
