package test.org.itscool.weber.user;

import java.util.List;

import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.testcase.WeberDbTestCase;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserDao;
import org.itscool.weber.user.Role;
import org.itscool.weber.user.RoleDao;

public class UserDaoTest  extends WeberDbTestCase{
    
    public void setUp(){
        this.initTables("test-db-data.xml");
    }
    
    public void testGetAllData(){
        UserDao userDao = new UserDao();
        List list = userDao.getAllData();
        
        assertNotNull(list);
        
        if( list.size() > 0){
            if(!(list.get(0) instanceof User)){
                fail("UserDao.getAllData()Ŏ擾CX^XUser^łȂ");
            }
        }
    }
    
    public void testGetUser(){
        UserDao userDao = new UserDao();
        
//		eXgΏۃ\bh
        User user = userDao.getUser(1);
        Role role = user.getRole();
        
        assertNotNull(user);
        assertEquals("test", user.getName() );
        assertEquals("test-pwd", user.getPwd());
        assertEquals(1, user.getRoleId());
        
        assertNotNull(role);
        assertEquals("test_role", role.getName());
        assertEquals(1, role.getId());
    }
    
    public void testGetUser2(){
        UserDao userDao = new UserDao();
        
//    	eXgΏۃ\bh
        User user = userDao.getUser("test_role", "test");
        Role role = user.getRole();
        
        assertNotNull(user);
        assertEquals("test", user.getName() );
        assertEquals("test-pwd", user.getPwd());
        assertEquals(1, user.getRoleId());
        
        assertNotNull(role);
        assertEquals("test_role", role.getName());
        assertEquals(1, role.getId());
    }
    
    public void testGetUser3(){
        UserDao userDao = new UserDao();
        Role role = new Role();
        role.setId(1);
        role.setName("test_role");
        
//    	eXgΏۃ\bh
        User user = userDao.getUser(role, "test");
        
        assertNotNull(user);
        assertEquals("test", user.getName() );
        assertEquals("test-pwd", user.getPwd());
        assertEquals(1, user.getRoleId());
        
    }
    
    public void testGetUsers(){
        UserDao userDao = new UserDao();
        List users = userDao.getUsers("test");
        for(int i=0; i<users.size(); i++){
            User user = (User)users.get(i);
            assertEquals("test", user.getName());
        }
    }
    
    public void testSave(){
        RoleDao roleDao = new RoleDao();
        List roles = roleDao.getAllData();
        Role role = (Role)roles.get(0);
        
        User user = new User();
        user.setName("SaveTestUser");
        user.setPwd("SaveTestPwd");
        user.setRoleId(role.getId());
        
        UserDao userDao = new UserDao();
        userDao.save(user);
        
        try{
            TransactionUtil.commitTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testUpdate(){
        UserDao userDao = new UserDao();
        
//    	eXgΏۃ\bh
        User user = userDao.getUser("test_role", "test");
        
        assertNotNull(user);
        assertEquals("test", user.getName() );
        assertEquals("test-pwd", user.getPwd());
        assertEquals(1, user.getRoleId());
        
        user.setName("update");
        user.setPwd("update-pwd");
        
        userDao.update(user);
        
        try{
            TransactionUtil.commitTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testDelete(){
        RoleDao roleDao = new RoleDao();
        List roles = roleDao.getAllData();
        Role role = (Role)roles.get(0);
        
        User user = new User();
        user.setName("DeleteTestUser");
        user.setPwd("DeleteTestPwd");
        user.setRoleId(role.getId());
        
        UserDao userDao = new UserDao();
        userDao.save(user);
        
        try{
            TransactionUtil.commitTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
        
        userDao.delete(user);
        
        try{
            TransactionUtil.commitTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
        
        User chkUser = userDao.getUser(role, "DeleteTestUser");
        assertNull(chkUser);
    }
}
