package org.itscool.commons.connection;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

/**
 * gUNVptB^<BR>
 * RlNVv[̏yуf[^ANZXwŎsꂽgUNV
 * ̎sʂR~bg/[obNstB^łB
 *
 * @author kanou
 *
 */
public class TransactionFilter implements Filter{
    private AbstractLog log;
    private boolean initFlag = false;
    
    /**
     * RlNVv[̏s܂<BR>
     * BeanFactoryCX^XgāAweb.xml̃ReLXgp[^udi-config-frameworkv
     * Ɏw肳ꂽBean`t@CConnectionMangaerCX^X擾܂B
     * BeanFactoryCX^XStartupFilterł炩ߏĂKv܂B
     *
     * @param filterConfig FilterConfigCX^X
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        BeanFactory factory = BeanFactory.getInstance();
        if( !factory.isInit() ){
            try{
                factory.createForUrl("di-config.xml");
            }catch(Exception ex){
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        
        try{
            if( factory.isDefined("Log") ){
                log = (AbstractLog)factory.getInstance("Log");
                if(!log.isInit()){
                    log = (AbstractLog)factory.createInstance("Log");
                }
            }else{
                log = SimpleLog.getInstance();
            }
        }catch(Exception ioe){
            throw new ServletException(ioe.getMessage());
        }
        
        try{
            ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
            manager.init();
            log.info("completed initialize instance='" + manager.getClass().getName() + "'" );
            log.info("ConnectionManager Info="+manager.toString());
            initFlag = true;
        }catch(Exception ex){
            log.error("ConnectionManager is not initialized (" + ex.getMessage() + ")");
        }
    }
    
    /**
     * chain.doFilter()sɃgUNṼR~bg/[obNs܂<BR>
     * gUNV͈ȉ̗ōs܂<BR>
     * (1) chain.doFilter()̌Ăяo<BR>
     * (2) TransactionUtil.getTransaction()ThreadLocalɃZbgĂTransaction
     * CX^X擾<BR>
     * (3) TransactionCX^X̃Xe[^X擾<BR>
     * (4) Xe[^XPLEASE_COMMIT̏ꍇ̓R~bgs܂<BR>
     * (4)' Xe[^XPLEASE_ROLLBACK̏ꍇ̓[obNs܂<BR>
     * (4)'' Exceptionꍇ[obNs܂<BR>
     * (4)''' ȊȌꍇ͉s܂<BR>
     * (5) ThreadLocalɃZbgꂽgUNVRlNVv[ɖ߂܂<BR>
     *
     * @param request ServletRequestCX^X
     * @param response ServletResponseCX^X
     */
    public void doFilter(ServletRequest request, ServletResponse response,
        FilterChain chain)
        throws IOException, ServletException {
        
        try {
            if( initFlag == true ){
                //gUNVJn܂B
                TransactionUtil.beginTransaction();
                //ƖWbNs܂B
                chain.doFilter(request, response);
                //gUNVXe[^XPLEASE_COMMITȂR~bgs
                if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_COMMIT ){
                    TransactionUtil.commitTransaction();
                    log.trace("COMMIT TRANSACTION");
                }else if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_ROLLBACK){
                    TransactionUtil.rollbackTransaction();
                    log.trace("ROLLBACK TRANSACTION");
                }
            }else{
                //ƖWbNs܂B
                chain.doFilter(request, response);
            }
        }catch(TransactionException e){
            try{
                if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_ROLLBACK){
                    TransactionUtil.rollbackTransaction();
                    log.trace("ROLLBACK TRANSACTION");
                }
            }catch(TransactionException te){}
            throw e;
        } finally {
            try{
                if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_ROLLBACK){
                    TransactionUtil.rollbackTransaction();
                    log.trace("ROLLBACK TRANSACTION");
                }
            }catch(TransactionException te){}
            log.trace("RELEASE TRANSACTION");
            //gUNVI܂B
            TransactionUtil.returnTransaction();
        }
    }
    
    /**
     * SẴRlNVARlNVv[J܂
     */
    public void destroy() {
        BeanFactory factory = BeanFactory.getInstance();
        ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
        manager.destroy();
    }
}
