package org.itscool.commons.pool;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

/**
 * IuWFNgv[NXł
 * @author KANO
 * 쐬F 2004/12/07
 */
public class ObjectPool{
    private ObjectPoolEventListener listener = null;
    private Vector pool = new Vector();
    private int initSize;        //v[̏l
    private int maxSize;        //v[̍ől
    
    /**
     * v[̏<br>
     * v[̍őTCYTCY菬ꍇPoolRuntimeExceptionX[܂
     * @param listener v[Cxg̔sƂȂIuWFNgw肵܂
     * @param initSize v[̏TCY
     * @param maxSize v[MAXTCY
     */
    public ObjectPool(ObjectPoolEventListener listener,
        int initSize, int maxSize ){
        this.listener = listener;
        this.initSize = initSize;
        this.maxSize = maxSize;
        if( maxSize < initSize ){
            throw new ObjectPoolRuntimeException("pool size is warning(maxSize < initSize).");
        }
    }
    
    /**
     * ݂̃v[TCYԂ܂
     * @return ݂̃v[TCYԂ܂
     */
    public int getPoolSize(){
        return pool.size();
    }
    
    /**
     * v[̏TCYԂ܂
     * @return v[̏TCYԂ܂
     */
    public int getInitSize(){
        return initSize;
    }
    
    /**
     * v[̊g\ȍőTCYԂ܂
     * @return g\ȃv[TCYԂ܂
     */
    public int getMaxSize(){
        return maxSize;
    }
    
    /**
     * v[Ԃ܂
     * @return v[Ԃ܂
     */
    public String toString(){
        StringBuffer sb = new StringBuffer();
        sb.append("[INIT SIZE]").append(initSize).append(", ");
        sb.append("[POOL SIZE]").append(pool.size()).append(", ");
        sb.append("[MAX  SIZE]").append(maxSize).append(", ");
        
        return sb.toString();
    }
    
    /**
     * vfVɒǉ܂<br>
     * v[TCYMAXTCYƓȏ̏ꍇ
     * PoolRuntimeExceptionX[܂B<br>
     * v[TCYgnotifyAll()𔭍sA̗vf̎擾҂
     * ĂIuWFNgN܂B
     * @param obj vf
     */
    public synchronized ObjectPoolElement addNewElement(Object obj) {
        if( pool.size() >= maxSize ){
            throw new ObjectPoolRuntimeException("pool size is MAX");
        }
        ObjectPoolElement element = new ObjectPoolElement();
        element.setObject(obj);
        element.setUse(false);
        pool.addElement(element);
        notifyAll();
        return element;
    }
    
//    private ObjectPoolElement createElement(Object obj){
//        ObjectPoolElement element = new ObjectPoolElement();
//        element.setObject(obj);
//        element.setUse(false);
//        return element;
//    }
//
    /**
     * gpς݂̗vfv[ɕԂ<br>
     * gpς݂̃v[ԋpnotifyAll()𔭍sA̗vf̎擾҂
     * ĂIuWFNgN܂B
     * @param obj vf
     */
    public synchronized void returnElement(Object obj){
        for(int i=0; i<pool.size(); i++ ){
            ObjectPoolElement elem = (ObjectPoolElement)pool.get(i);
            if(elem.getObject() == obj){
                elem.setUse(false);
            }
        }
        //pool.addElement(obj);
        notifyAll();
    }
    
    /**
     * v[vf擾<BR>
     * vfsĂꍇdoMissingElementEvent()𔭍s
     * v[TCY̊gƃv[ɐVvf̒ǉv܂<br>
     * v[TCYMAXTCYɒBĂꍇ̓v[TCY̊g
     * ͍sꂸAnullvfԂ܂B
     *
     * @return vfԂ܂
     */
    public synchronized Object getElement() {
        Object obj = null;
        for(int i=0; i<pool.size(); i++ ){
            ObjectPoolElement elem = (ObjectPoolElement)pool.get(i);
            if( !elem.isUse() ){
                elem.setUse(true);
                return elem.getObject();
            }
        }
        
        //MAXTCYw肳ĂȂꍇ
        //݂̃v[TCYMAXTCY菬ꍇ
        //v[̒ǉvCxg𔭍s
        if(pool.size() < maxSize){
            obj = listener.doMissingElementEvent();
            if( obj != null ){
                ObjectPoolElement elem = addNewElement(obj);
                elem.setUse(true);
                return elem.getObject();
            }
        }
        //return null;
        throw new ObjectPoolRuntimeException("pool is no buffer.");
//        if (pool.size() > 0) {
//            obj = pool.firstElement();
//            pool.removeElementAt(0);
//            restSize--;
//        //MAXTCYw肳ĂȂꍇ
//        //݂̃v[TCYMAXTCY菬ꍇ
//        //v[̒ǉvCxg𔭍s
//        }else if(poolSize < maxSize){
//            obj = listener.doMissingElementEvent();
//            if( obj != null ){
//                poolSize++;
//            }
//        }
//        return obj;
    }
    
    /**
     * v[vf擾<BR>
     * vfsĂꍇtimeoutbŎw肳ꂽԂ
     * ҂܂<br>
     * ̌Aēxvf̎擾݂܂<BR>
     * vf̎擾ɎsꍇnullԂ܂
     * @return vfԂ܂
     */
    public synchronized Object getElement(int timeout) {
        long startTime = new Date().getTime();
        Object obj = null;
        while ((obj = getElement()) == null) {
            try {
                wait(timeout);
            }catch (InterruptedException e) {}
            if ((new Date().getTime() - startTime) >= timeout) {
                // Timeout has expired
                //return null;
                throw new ObjectPoolRuntimeException("pool is no buffer.");
            }
        }
        return obj;
    }
    /**
     * SĂ̗vf܂
     */
    public synchronized void release() {
        Enumeration element = pool.elements();
        while (element.hasMoreElements()) {
            ObjectPoolElement elem = (ObjectPoolElement)element.nextElement();
            listener.doReleaseElementEvent(elem.getObject());
        }
        pool.removeAllElements();
    }
    
}

