package org.itscool.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ByteUtil {
    public static final byte[] LINE= {13, 10};
    
    /**
     * 1s̃oCgz擾܂
     * @param buffer oCgz
     * @param startPos 擾Jnʒu
     * @return 1s̃oCgzԂ܂
     */
    public static byte[] getLineCrLf(byte[] buffer, int startPos){
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        int bufSize = buffer.length;
        
        //JnsiIsjL[[h
        for(int i=startPos;true;i++) {
            if((i+1)>=bufSize){
                break;
            }else if((buffer[i]==LINE[0])&&(buffer[i+1]==LINE[1])) {
                break;
            }
            bo.write(buffer[i]);
        }
        byte[] byteArray = bo.toByteArray();
        try{
            bo.close();
        }catch(IOException e){}
        
        return byteArray;
    }
    
    /**
     * bufferkey܂܂Ăŏ̃oCgʒu擾
     * @param buffer oCgz
     * @param key ΏۃL[
     * @return ŏɌoCgʒu
     */
    public static int indexof(byte[] buffer, byte[] key){
        
        int bufSize = buffer.length;
        int keySize = key.length;
        for(int i=0, j=0; i<bufSize; i++ ){
            //sv
            if(buffer[i]!=key[j]){
                j=0;
                continue;
                //Sv
            }else if( keySize == (j+1) ){
                return (i-keySize);
                //v
            }else{
                j++;
            }
        }
        return -1;
    }
    
    /**
     * Ŏw肵bytez񂩂̃GA𒊏oAʂbytez
     * Ԃ܂
     * @param dataB f[^bytez
     * @param off oJnʒu
     * @param len oJnʒũf[^
     * @return oꂽbytezԂ܂
     * @throws IOException
     */
    public static byte[] copyByteData(byte[] dataB, int off, int len){
        try{
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            bo.write(dataB, off, len);
            
            byte[] result = bo.toByteArray();
            bo.close();
            
            return result;
        }catch(IOException ioe){
            return null;
        }
    }
    
    /**
     * Ɏw肳ꂽbytezHEXɕϊ܂
     * @param data bytez
     * @return HEXɕϊꂽ
     */
    public static String convHexString(byte data){
        String hex = Integer.toString(data, 16);
        if(hex.length()==1){
            hex = " 0"+hex;
        }else if(hex.length()==2){
            hex = " "+hex;
        }
        return hex;
    }
    
    public static String debugHex(byte[] data){
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("[BINARY]");
        sb.append("================================================================");
        sb.append(line);
        sb.append(" 00  01  02  03  04  05  06  07  08  09  0A  0B  0C  0D  0E  0F");
        sb.append(line);
        sb.append("----------------------------------------------------------------");
        sb.append(line);
        for(int i=0; i<data.length; i++){
            sb.append(convHexString(data[i])+" ");
            if( (i+1)%16 ==0){
                sb.append(line);
            }
        }
        sb.append(line);
        sb.append("================================================================");
        sb.append(line);
        return sb.toString();
    }
    
    public static String debugHex(String data){
        return debugHex(data.getBytes());
    }
}
