/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.commons.dao.RecordMapFkFactory;
import org.itscool.commons.dao.RecordMapOneToManyFactory;

public class PreparedStatementWrapper {
    public static final int MAP_KIND_TABLEMANE_IS_CLASS = 0;
    public static final int MAP_KIND_QUERY_ONE_CLASS = 1;
    public static final int MAP_KIND_ASNAME_IS_CLASS = 2;
    private PreparedStatement pstmt;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$lang$String;

    public PreparedStatementWrapper(PreparedStatement pstmt) {
        this.pstmt = pstmt;
    }

    public void setValue(int id, String value) {
        try {
            this.pstmt.setString(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, byte value) {
        try {
            this.pstmt.setByte(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, short value) {
        try {
            this.pstmt.setShort(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, int value) {
        try {
            this.pstmt.setInt(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, long value) {
        try {
            this.pstmt.setLong(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, double value) {
        try {
            this.pstmt.setDouble(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, float value) {
        try {
            this.pstmt.setFloat(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, byte[] value) {
        try {
            this.pstmt.setBytes(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, InputStream value) {
        try {
            this.pstmt.setBinaryStream(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, Blob value) {
        try {
            this.pstmt.setBlob(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, Reader value) {
        try {
            this.pstmt.setCharacterStream(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, java.util.Date value) {
        try {
            Date sqlValue = new Date(value.getTime());
            this.pstmt.setDate(id, sqlValue);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public void setValue(int id, Object value) {
        try {
            this.pstmt.setObject(id, value);
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public List select(Class entity) {
        return this.select(entity, 0);
    }

    public List select(Class entity, int tree) {
        LinkedList<Object> result = new LinkedList<Object>();
        ResultSet rs = null;
        try {
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
            rs = this.pstmt.executeQuery();
            String currentTable = null;
            if (tree == 1) {
                currentTable = gRecordMap.getTableName();
            }
            List recordList = this.createRecordList(rs, currentTable, tree);
            for (int i = 0; i < recordList.size(); ++i) {
                HashMap record = (HashMap)recordList.get(i);
                Object newBean = this.createBean(record, gRecordMap, tree);
                if (newBean == null) continue;
                Set keySet = fkRecordMaps.keySet();
                Iterator it = keySet.iterator();
                while (it.hasNext()) {
                    Object fkBean;
                    String fkPropertyName = (String)it.next();
                    RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(fkPropertyName);
                    if (fkRecordMap == null || (fkBean = this.createBean(record, fkRecordMap, tree)) == null) continue;
                    BeanUtil.setProperty(newBean, fkPropertyName, fkBean);
                }
                HashMap oneToManyRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(entity);
                Set mKeySet = oneToManyRecordMaps.keySet();
                Iterator mIt = mKeySet.iterator();
                int childCount = 0;
                while (mIt.hasNext()) {
                    ArrayList<Object> childs = new ArrayList<Object>();
                    String propertyName = (String)mIt.next();
                    RecordMap oneToManyRecordMap = (RecordMap)oneToManyRecordMaps.get(propertyName);
                    for (childCount = i; childCount < recordList.size(); ++childCount) {
                        HashMap child = (HashMap)recordList.get(childCount);
                        Object oneToManyObj = this.createBean(child, oneToManyRecordMap, tree);
                        childs.add(oneToManyObj);
                        Object chkObj = this.createBean(child, gRecordMap, tree);
                        if (RecordMap.isEquals(newBean, chkObj, gRecordMap)) continue;
                        if (childCount <= 1) break;
                        --childCount;
                        break;
                    }
                    BeanUtil.setProperty(newBean, propertyName, childs);
                }
                if (oneToManyRecordMaps.size() > 0) {
                    i = childCount;
                }
                result.add(newBean);
            }
            LinkedList<Object> linkedList = result;
            return linkedList;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private List createRecordList(ResultSet rs, String currentTable, int tree) throws SQLException {
        ArrayList recordList = new ArrayList();
        while (rs.next()) {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            HashMap<String, HashMap<String, Object>> record = new HashMap<String, HashMap<String, Object>>();
            for (int i = 0; i < columnCount; ++i) {
                HashMap<String, Object> datasOfTable;
                String colName = metaData.getColumnName(i + 1);
                String colAsName = metaData.getColumnLabel(i + 1);
                String tableName = metaData.getTableName(i + 1);
                if (currentTable != null) {
                    tableName = currentTable;
                }
                Object value = rs.getObject(i + 1);
                if (tree == 2) {
                    int tableIndex = colAsName.indexOf("_AS_");
                    if (tableIndex >= 0) {
                        tableName = colAsName.substring(0, tableIndex);
                    }
                    int colNameIndex = tableIndex + "_AS_".length();
                    if (colAsName.length() > colNameIndex && tableIndex >= 0) {
                        colAsName = colAsName.substring(colNameIndex, colAsName.length());
                    }
                }
                if ((datasOfTable = (HashMap<String, Object>)record.get(tableName)) == null) {
                    datasOfTable = new HashMap<String, Object>();
                    record.put(tableName, datasOfTable);
                }
                datasOfTable.put(colAsName, value);
            }
            recordList.add(record);
        }
        return recordList;
    }

    private Object createBean(HashMap record, RecordMap recordMap, int tree) {
        String entityName = recordMap.getClassName();
        String tableName = recordMap.getTableName();
        HashMap datasOfTable = (HashMap)record.get(tableName);
        if (datasOfTable == null) {
            return null;
        }
        Object newBean = BeanUtil.createInstance(entityName);
        Set datasKeySet = datasOfTable.keySet();
        Iterator datasIt = datasKeySet.iterator();
        while (datasIt.hasNext()) {
            Class type;
            String colAsName = (String)datasIt.next();
            Object value = datasOfTable.get(colAsName);
            FieldMap field = recordMap.getFieldByFieldName(colAsName);
            String propertyName = field.getPropertyName();
            if (value instanceof Date) {
                value = new java.util.Date(((Date)value).getTime());
            } else if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                value = new java.util.Date(ts.getTime());
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                type = BeanUtil.getReturnType(newBean, propertyName);
                if (type.isAssignableFrom(class$java$io$InputStream == null ? PreparedStatementWrapper.class$("java.io.InputStream") : class$java$io$InputStream)) {
                    try {
                        value = blob.getBinaryStream();
                    }
                    catch (SQLException se) {}
                } else if (type.isAssignableFrom(array$B == null ? PreparedStatementWrapper.class$("[B") : array$B)) {
                    try {
                        value = blob.getBytes(0L, (int)blob.length());
                    }
                    catch (SQLException se) {}
                }
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                type = BeanUtil.getReturnType(newBean, propertyName);
                if (type.isAssignableFrom(class$java$io$Reader == null ? PreparedStatementWrapper.class$("java.io.Reader") : class$java$io$Reader)) {
                    try {
                        value = clob.getCharacterStream();
                    }
                    catch (SQLException se) {}
                } else if (type.isAssignableFrom(class$java$lang$String == null ? PreparedStatementWrapper.class$("java.lang.String") : class$java$lang$String)) {
                    try {
                        value = clob.getSubString(0L, (int)clob.length());
                    }
                    catch (SQLException se) {
                        // empty catch block
                    }
                }
            }
            BeanUtil.setProperty(newBean, propertyName, value);
        }
        return newBean;
    }

    public Records select() {
        ResultSet rs = null;
        try {
            rs = this.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            Records records = new Records();
            while (rs.next()) {
                Record record = new Record();
                for (int i = 0; i < columnCount; ++i) {
                    String colName = metaData.getColumnName(i + 1);
                    String colAsName = metaData.getColumnLabel(i + 1);
                    String tableName = metaData.getTableName(i + 1);
                    if (!colAsName.equals("")) {
                        colName = colAsName;
                    }
                    colName = colName.toUpperCase();
                    Object value = rs.getObject(i + 1);
                    String key = tableName + "." + colName;
                    key = key.toUpperCase();
                    record.put(key, value);
                }
                records.add(record);
            }
            Records records2 = records;
            return records2;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public ResultSet executeQuery() {
        try {
            ResultSet ret = this.pstmt.executeQuery();
            return ret;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public int executeUpdate() {
        try {
            int ret = this.pstmt.executeUpdate();
            return ret;
        }
        catch (SQLException e) {
            throw new TransactionException(e.getMessage());
        }
    }
}

