/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.itscool.commons.util.NumberFormatUtil;

public class DateFormatUtil {
    private static final int[] DAY_OF_KIND = new int[]{4, 6, 9, 11};

    public static Date createDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        Date date = cal.getTime();
        return date;
    }

    public static Date createMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        Date date = cal.getTime();
        return date;
    }

    public static int getMaxDay(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        if (month == 2) {
            if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                return 29;
            }
            return 28;
        }
        for (int i = 0; i < DAY_OF_KIND.length; ++i) {
            if (DAY_OF_KIND[i] != month) continue;
            return 30;
        }
        return 31;
    }

    public static Calendar getLastMonthWeek(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        int firstYobi = cal.get(7);
        cal.add(5, -(firstYobi - 1));
        return cal;
    }

    public static String encodeYYMMDDString() {
        Calendar cal = Calendar.getInstance();
        return DateFormatUtil.encodeYYMMDDString(cal);
    }

    public static String encodeYYMMDDString(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String yearStr = String.valueOf(year).substring(2, 4);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        return ret;
    }

    public static String encodeYYMMDDString(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String yearStr = String.valueOf(year).substring(2, 4);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        return ret;
    }

    public static String encodeYYYYMMDDString() {
        Calendar cal = Calendar.getInstance();
        return DateFormatUtil.encodeYYYYMMDDString(cal);
    }

    public static String encodeYYYYMMDDString(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String yearStr = String.valueOf(year);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        return ret;
    }

    public static Calendar decodeYYYYMMDDString(String yyyymmdd) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        try {
            StringTokenizer dataSt = new StringTokenizer(yyyymmdd, "/");
            dataSt.hasMoreTokens();
            int year = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int month = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int day = Integer.parseInt(dataSt.nextToken());
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, day);
            return cal;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isCalendar(String str) {
        Calendar cal = DateFormatUtil.decodeYYYYMMDDString(str);
        return cal != null;
    }

    public static Date parse(String str) {
        String format = DateFormatUtil.searchDateFormat(str = str.trim());
        if (format == null || str == null || str.length() == 0) {
            return null;
        }
        Date date = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat(format);
        try {
            date = sdf1.parse(str);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static String searchDateFormat(String data) {
        if (data == null) {
            return null;
        }
        String koubun = "\\d{4,4}/\\d{1,2}/\\d{1,2}";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yyyy/MM/dd";
        }
        koubun = "\\d{2,2}/\\d{1,2}/\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yy/MM/dd";
        }
        koubun = "\\d{4,4}-\\d{1,2}-\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yyyy-MM-dd";
        }
        koubun = "\\d{2,2}-\\d{1,2}-\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yy-MM-dd";
        }
        koubun = "\\d{4,4}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yyyy/MM/dd hh:mm:ss";
        }
        koubun = "\\d{2,2}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yy/MM/dd hh:mm:ss";
        }
        koubun = "\\d{4,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yyyy-MM-dd hh:mm:ss";
        }
        koubun = "\\d{2,2}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yy-MM-dd hh:mm:ss";
        }
        koubun = "\\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "hh:mm:ss";
        }
        koubun = "\\d{1,2}/\\d{1,2}/\\d{4,4}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "MM/dd/yyyy";
        }
        koubun = "\\d{1,2}/\\d{1,2}/\\d{4,4} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "MM/dd/yyyy hh:mm:ss";
        }
        koubun = "\\d{8,8}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yyyyMMdd";
        }
        koubun = "\\d{6,6}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if (matcher.matches()) {
            return "yyMMdd";
        }
        return null;
    }

    public static void main(String[] argv) {
        System.out.println(DateFormatUtil.parse("2004/05/01"));
        System.out.println(DateFormatUtil.parse("04/05/01"));
        System.out.println(DateFormatUtil.parse("04/5/1"));
        System.out.println(DateFormatUtil.parse("2004-05-01"));
        System.out.println(DateFormatUtil.parse("04-05-01"));
        System.out.println(DateFormatUtil.parse("04-5-1"));
        System.out.println(DateFormatUtil.parse("2004/05/01 23:59:30"));
        System.out.println(DateFormatUtil.parse("04/05/01 23:59:30"));
        System.out.println(DateFormatUtil.parse("04/5/1 23:59:30"));
        System.out.println(DateFormatUtil.parse("2004-05-01 23:59:30"));
        System.out.println(DateFormatUtil.parse("04-05-01 23:59:30"));
        System.out.println(DateFormatUtil.parse("04-5-1 23:59:30"));
        System.out.println(DateFormatUtil.parse("01:01:01"));
        System.out.println(DateFormatUtil.parse("1:1:1"));
        System.out.println(DateFormatUtil.parse("05/01/2004"));
        System.out.println(DateFormatUtil.parse("05/01/2004 23:59:30"));
        System.out.println(DateFormatUtil.parse("20040501"));
        System.out.println(DateFormatUtil.parse("040501"));
        System.out.println("0501-->" + DateFormatUtil.parse("0501"));
        System.out.println("05/01-->" + DateFormatUtil.parse("05/01"));
        System.out.println("05-01-->" + DateFormatUtil.parse("05-01"));
    }
}

