/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.itscool.commons.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DomParser {
    protected Document document;

    public DomParser() {
    }

    public DomParser(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void parseText(String message, String enc) throws Exception {
        Document document;
        byte[] buf = message.getBytes(enc);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream bIn = new ByteArrayInputStream(buf);
        this.document = document = builder.parse(bIn);
    }

    public void parse(String path, String encode) throws Exception {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        FileInputStream fin = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader((InputStream)fin, encode);
        InputSource is = new InputSource();
        this.document = builder.parse(is);
        isr.close();
        fin.close();
    }

    public void save(String path, String outEncode) throws Exception {
        FileOutputStream out = new FileOutputStream(path);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)out, outEncode);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("encoding", outEncode);
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(fw);
        transformer.transform(source, result);
        out.flush();
        out.close();
    }

    public Node getFirstElementsByTagNames(String nodeNames) throws Exception {
        NodeList nodeList = this.document.getChildNodes();
        NodeList resultList = this.getElementsByTagNames(nodeList, nodeNames);
        if (resultList.getLength() == 0) {
            return null;
        }
        return resultList.item(0);
    }

    public NodeList getElementsByTagNames(String nodeNames) throws Exception {
        NodeList nodeList = this.document.getChildNodes();
        return this.getElementsByTagNames(nodeList, nodeNames);
    }

    public String getFirstTextElementByTagNames(NodeList nodeList, String nodeNames) throws Exception {
        Node firstNode = this.getFirstElementsByTagNames(nodeList, nodeNames);
        NodeList childs = firstNode.getChildNodes();
        if (childs.getLength() == 0) {
            return null;
        }
        return childs.item(0).getNodeValue();
    }

    public Node getFirstElementsByTagNames(NodeList nodeList, String nodeNames) throws Exception {
        NodeList resultNodeList = this.getElementsByTagNames(nodeList, nodeNames);
        if (resultNodeList.getLength() == 0) {
            return null;
        }
        return resultNodeList.item(0);
    }

    public NodeList getElementsByTagNames(NodeList nodeList, String nodeNames) throws Exception {
        List tagNameList = StringUtil.split(nodeNames, ".");
        Element parentDummyNode = this.document.createElement("RESULT_TEMP_NODE");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (tagNameList.size() == 0) {
                return null;
            }
            if (!node.getNodeName().equals((String)tagNameList.get(0))) continue;
            if (tagNameList.size() == 1) {
                parentDummyNode.appendChild(node);
                continue;
            }
            NodeList childNodeList = node.getChildNodes();
            this.createNodeListByTagNames(parentDummyNode, tagNameList, childNodeList, 1);
        }
        return parentDummyNode.getChildNodes();
    }

    protected void createNodeListByTagNames(Node parentDummyNode, List tagNameList, NodeList nodeList, int nodeFloor) {
        int nodeNum = nodeList.getLength();
        for (int i = 0; i < nodeNum; ++i) {
            String childNodeName;
            Node childNode = nodeList.item(i);
            String checkNodeName = (String)tagNameList.get(nodeFloor);
            if (!checkNodeName.equals(childNodeName = childNode.getNodeName())) continue;
            if (nodeFloor + 1 == tagNameList.size()) {
                parentDummyNode.appendChild(childNode.cloneNode(true));
                continue;
            }
            NodeList magoNodeList = childNode.getChildNodes();
            this.createNodeListByTagNames(parentDummyNode, tagNameList, magoNodeList, nodeFloor + 1);
        }
    }
}

