package test.org.itscool.commons.angou;

import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.itscool.commons.util.AngouUtil;

public class AngouTest extends TestCase{
    
    public AngouTest(String name){
        super(name);
    }
    
    /**
     * ÍeXgiP[Xj
    */
    public void testEncrypt(){
        try{
            //[UŃpX[h(pwd)Í
            byte[] pwdAngou = AngouUtil.encrypt("user", "pwd");
            
            assertNotNull("readBytes()NULLԂ", pwdAngou);
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * eXgiP[Xj
    */
    public void testDecrypt(){
        try{
            //Í
            byte[] pwdAngou = AngouUtil.encrypt("user", "pwd");
            //
            String pwd = AngouUtil.decrypt("user", pwdAngou );
            
            assertEquals("ꂽ񂪈ÍȌƈႢ܂", "pwd", pwd);
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * ÍeXgiÍL[NULL)
    */
    public void testEncryptKeyIsNull(){
        try{
            //[UŃpX[h(pwd)Í
            byte[] pwdAngou = AngouUtil.encrypt(null, "pwd");
            
            assertNull("ÍꂽpX[hNULLłȂ", pwdAngou);
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * ÍeXgiÍΏۏNULL)
    */
    public void testEncryptDataIsNull(){
        try{
            //[UŃpX[h(pwd)Í
            byte[] pwdAngou = AngouUtil.encrypt("user", null);
            
            assertNull("ÍꂽpX[hNULLłȂ", pwdAngou);
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
    }
    
    /**
     * eXgiL[svj
    */
    public void testDecryptDifferentKey(){
        try{
            //Í
            byte[] pwdAngou = AngouUtil.encrypt("user", "pwd");
            //
            String pwd = AngouUtil.decrypt("aaa", pwdAngou );
            
            assertNull("ꂽpX[hNULLłȂ", pwd);
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
            
    }
    
    /**
     * eXgiÍsvj
     * Í̂܂ܕԂ̂
    */
    public void testDecryptDifferentAngouData(){
        try{
            //Í
            //byte[] pwdAngou = Angou.encrypt("user", "pwd");
            //
            String pwd = AngouUtil.decrypt("user", (new String("aaa")).getBytes() );
            
            assertEquals("ꂽ񂪈ÍƈvȂ", "aaa", pwd);
            
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
            
    }
	public static Test suite() {
		return new TestSuite(AngouTest.class);
	}
    
}

