package test.org.itscool.commons.dao3;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.weber.testcase.WeberDbTestCase;

public class DeleteChildDaoTest extends WeberDbTestCase{
    public void setUp(){
        this.clearTables();
        this.initTables("test/org/itscool/commons/dao3/test-db-data.xml");
    }
    
    public void testInsert(){
        DeleteBean company = new DeleteBean();
        company.setId(10);
        company.setName("hoge com");
        
        DeleteChild child = new DeleteChild();
        child.setId(100);
        child.setParentId(10);
        child.setName("hoge child");
        child.setDeleteBean(company);
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DeleteBean.class);
        Criteria crt2 = new Criteria(DeleteChild.class);
        
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            int insertCount = dao.insert(crt, company);
            assertEquals("DeleteBean insert count", 1, insertCount);
            insertCount = dao.insert(crt2, child);
            assertEquals("DeleteChild insert count", 1, insertCount);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
            TransactionUtil.commitTransaction();
        }catch( Exception e ){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
    }
    
    public void testDelete(){
        DeleteBean parent = new DeleteBean();
        parent.setId(20);
        parent.setName("hoge com");
        
        DeleteChild child = new DeleteChild();
        child.setId(200);
        child.setParentId(20);
        child.setName("hoge child");
        child.setDeleteBean(parent);
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DeleteBean.class);
        Criteria crt2 = new Criteria(DeleteChild.class);
        
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            int insertCount = dao.insert(crt, parent);
            assertEquals("DeleteBean insert count", 1, insertCount);
            insertCount = dao.insert(crt2, child);
            assertEquals("DeleteChild insert count", 1, insertCount);
            
            int deleteCount = dao.delete(crt);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
            
            TransactionUtil.commitTransaction();
        }catch( Exception e ){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
    }
    
}
