/*
 * ElementFuncTest.java
 *
 * Created on 2007/03/19, 14:02
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.stylist.el;

import java.util.List;

import junit.framework.TestCase;

import org.itscool.stylist.el.ElementFunc;

public class ElementFuncTest extends TestCase{
    public void testCreateFuncList(){
        String el1="objectName.func(aaa, bbb, ccc)";
        ElementFunc func = ElementFunc.createFuncList(el1);
        assertEquals("className", func.getClassName(), "ObjectName");
        assertEquals("funcName", func.getFuncName(), "func");
        List argList = func.getArgList();
        assertEquals("arg1", "aaa", argList.get(0).toString());
        assertEquals("arg2", "bbb", argList.get(1).toString());
        assertEquals("arg3", "ccc", argList.get(2).toString());
        assertEquals("arg num", 3, argList.size());
    }
    
    public void testCreateFuncList2(){
        String el1="objectName.func_aaa(a, b, c, 1)";
        ElementFunc func = ElementFunc.createFuncList(el1);
        assertEquals("className", func.getClassName(), "ObjectName");
        assertEquals("funcName", func.getFuncName(), "func_aaa");
        List argList = func.getArgList();
        assertEquals("arg1", "a", argList.get(0).toString());
        assertEquals("arg2", "b", argList.get(1).toString());
        assertEquals("arg3", "c", argList.get(2).toString());
        assertEquals("arg4", "1", argList.get(3).toString());
        assertEquals("arg num", 4, argList.size());
    }
    
    public void testCreateFuncList3(){
        String el1="objectName.func_aaa('a', \"b\", c, 1)";
        ElementFunc func = ElementFunc.createFuncList(el1);
        assertEquals("className", func.getClassName(), "ObjectName");
        assertEquals("funcName", func.getFuncName(), "func_aaa");
        List argList = func.getArgList();
        assertEquals("arg1", "'a'", argList.get(0).toString());
        assertEquals("arg2", "\"b\"", argList.get(1).toString());
        assertEquals("arg3", "c", argList.get(2).toString());
        assertEquals("arg4", "1", argList.get(3).toString());
        assertEquals("arg num", 4, argList.size());
    }
}
