package org.itscool.commons.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.itscool.commons.pool.ObjectPool;
import org.itscool.commons.pool.ObjectPoolEventListener;

/**
 * Ǝ̃RlNVv[TransactionCX^X̐ǗNXł<BR>
 * <BR>
 * ConnectionPoolDBƂ̐ڑɈԎԂ_lāAڑ
 * ɃN[YɎg܂킷Ƃ@łB<BR>
 * g̓RlNVv[ɋ󂢂ĂRlNVȂmFA
 * ΂AȂ΍ő吔ɒB܂ŐVKɃRlNV𒣂Ăg
 * Ƃ菇ɂȂ܂B<BR>
 *
 * AvP[V̏ƏI邢ServletFilterinit()destroy()
 * ConnectionMangeȑƏI悤ɂĂ<P>
 *
 * ConnectionManager manager = ConnectionManger.getInstance();<P>
 *
 * manager.init();<B>
 * manager.destroy();<B>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class JdbcConnectionManager implements ConnectionManager, ObjectPoolEventListener{
    private static JdbcConnectionManager instance = null;
    private ObjectPool pool;				//IuWFNgv[
    private String drvname;                // JDBChCo
    private String pwd;                    // pX[h
    private String url;                    // URL
    private String user;                  // [U
    private int timeout;                  // Connection擾̃^CAEg
    private boolean initFlg = false;     //tO
    private int initSize = 0;				//v[̏TCY
    private int maxSize = 1;				//v[MAXTCY
    private boolean mode = false;        // AutoCommit[h
    private boolean showSql = false;		//SQL\tO
    
    public String toString(){
        StringBuffer sb = new StringBuffer();
        sb.append("Driver Name:").append(drvname);
        sb.append(", ");
        sb.append("timeout:").append(timeout);
        sb.append(", ");
        sb.append("initSize:").append(initSize);
        sb.append(", ");
        sb.append("maxSize:").append(maxSize);
        sb.append(", ");
        sb.append("mode:").append(mode);
        sb.append(", ");
        sb.append("showSql:").append(showSql);
        return sb.toString();
    }
    
    /**
     * BConnectionManagerCX^X擾܂
     * @return BConnectionMangerCX^XԂ܂
     */
    public static JdbcConnectionManager getInstance(){
        if( instance == null){
            instance = new JdbcConnectionManager();
        }
        return instance;
    }
    
    /**
     * f[^x[Xڑ}l[W܂
     * @param url f[^x[XڑURL
     * @param user [U
     * @param pwd pX[h
     * @param drvname JDBChCo
     * @param initSize v[TCY
     * @param maxSize őv[TCY
     * @param mode AutoCommit[h
     * @param timeout ConnectionCX^X擾̃^CAEg.
     * (-1)w肵ꍇ̓^CAEg
     * @throws TransactionException
     */
    public void init(String url, String user, String pwd, String drvname,
        int initSize, int maxSize, boolean mode, int timeout, boolean showSql) throws TransactionException{
        pool = new ObjectPool(this, initSize, maxSize);
        
        this.url = url;
        this.user = user;
        this.pwd = pwd;
        this.mode = mode;
        this.drvname = drvname;
        this.timeout = timeout;
        this.showSql = showSql;
        this.initSize = initSize;
        this.maxSize = maxSize;
        for( int i=0; i<initSize; i++ ){
            pool.addNewElement( (Object)newTransaction() );
        }
        initFlg = true;
    }
    
    public void init(){
        pool = new ObjectPool(this, initSize, maxSize);
        for( int i=0; i<initSize; i++ ){
            pool.addNewElement( (Object)newTransaction() );
        }
    }
    
    /**
     * VKRlNV̍쐬
     * @return ConnectionCX^Xv[擾܂
     * @throws TransactionException
     */
    private Transaction newTransaction() throws TransactionException{
        Connection con = null;
        Transaction trn = null;
        try {
            if(drvname==null || drvname.length() == 0){
                throw new TransactionException("jdbc name is null.");
            }else if(url ==null || url.length() == 0){
                throw new TransactionException("connection url is null.");
            }
            Class.forName(drvname);
            con = DriverManager.getConnection(url, user, pwd);
//add 2006/12/19 kano start vNVɊResultSetAPrepardStatement̎N[YǉΉ
            con = ProxyConnection.createProxy(con);
//add 2006/12/19 kano end vNVɊResultSetAPrepardStatement̎N[YǉΉ
            con.setAutoCommit(mode);
            trn = new Transaction(con);
            trn.setShowSql(showSql);
        }catch(ClassNotFoundException e){
            throw new TransactionException(e);
        }catch (SQLException se){
            throw new TransactionException(se);
        }
        return trn;
    }
    
    /**
     * ConnectionManagerCX^XĂ邩肵܂
     * @return ς݂̏ꍇtrueԂ܂
     */
    public boolean isInit(){
        return initFlg;
    }
    
    /**
     * TransactionCX^Xv[擾܂
     * v[TransactionCX^XȂꍇnullԂ܂
     * @return TransactionCX^XԂ܂
     */
    public Transaction getTransaction(){
        if( timeout > 0 ){
            return (Transaction)pool.getElement(timeout);
        }else{
            return (Transaction)pool.getElement();
            
        }
    }
    
    /**
     * svɂȂTransactionCX^Xv[ɕԂ܂
     * @param trn svɂȂTransactionCX^X
     */
    public void returnTransaction(Transaction trn){
        if(trn == null ){
            trn = newTransaction();
        }else if(trn.isClosed()){
            trn = newTransaction();
        }
        pool.returnElement(trn);
    }
    
    /**
     * RlNVv[JAI܂B
     */
    public void destroy(){
        if(pool != null ){
            pool.release();
        }
        pool = null;
        initFlg = false;
    }
    
    /**
     * org.itscool.commons.pool.PoolNXvf̒ǉv
     * 邽߂ɌĂ΂Cxgł<br>
     * VConnectionCX^X𐶐APoolNXɕԂ܂<br>
     * org.itscool.commons.pool.PoolNXȊO炱̃\bh
     * Ă΂Ȃł
     */
    public Object doMissingElementEvent(){
        Transaction trn = newTransaction();
        return trn;
    }
    
    /**
     * org.itscool.commons.pool.PoolNXĂ΂
     * Cxgł<br>
     * w肳ꂽConnectionvf̃N[Y{܂<br>
     * org.itscool.commons.pool.PoolNXȊO炱̃\bh
     * Ă΂Ȃł
     * @param obj w肳ꂽvf
     */
    public void doReleaseElementEvent(Object obj){
        Transaction trn = (Transaction) obj;
        try {
            trn.close();
        }catch (TransactionException e) {
            throw new TransactionException(e);
        }
    }
    
    /**
     * ݂̃v[TCYԂ܂
     * @return ݂̃v[TCYԂ܂
     */
    public int getPoolSize(){
        if( pool != null ){
            return pool.getPoolSize();
        }else{
            return -1;
        }
    }
    
    /**
     * v[̏TCYԂ܂
     * @return v[̏TCYԂ܂
     */
    public int getInitSize(){
        return initSize;
    }
    
    /**
     * v[̊g\ȍőTCYԂ܂
     * @return g\ȃv[TCYԂ܂
     */
    public int getMaxSize(){
        return maxSize;
    }
    
    /**
     * JDBChCoZbg܂
     * @param drvname JDBChCo
     */
    public void setDrvname(String drvname) {
        this.drvname = drvname;
    }
    
    /**
     * AutoCommit[hZbg܂
     * @param mode AutoCommit[h
     */
    public void setMode(boolean mode) {
        this.mode = mode;
    }
    
    /**
     * f[^x[XRlNṼpX[hZbg܂
     * @param pwd pX[h
     */
    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
    
    /**
     * SQL\[hZbg܂
     * @param showSql SQL\[h
     */
    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }
    
    /**
     * RlNV^CAEgZbg܂
     * @param timeout RlNV^CAEg
     */
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
    
    /**
     * JDBCڑURLZbg܂
     * @param url JDBCڑURL
     */
    public void setUrl(String url) {
        this.url = url;
    }
    
    /**
     * JDBCڑ[UZbg܂
     * @param user
     */
    public void setUser(String user) {
        this.user = user;
    }
    
    /**
     * RlNVv[̏TCYZbg܂
     * @param initSize RlNVv[̏TCY
     */
    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }
    
    /**
     * RlNVv[̍őTCYZbg܂
     * @param maxSize
     */
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
    
    /**
     * JDBChCo擾܂
     * @return JDBChCo
     */
    public String getDrvname() {
        return drvname;
    }
    
    /**
     * ConnectionMangerCX^X̏󋵂擾܂
     * @return ς݂̏ꍇtrueԂ܂
     */
    public boolean isInitFlg() {
        return initFlg;
    }
    
    /**
     * AutoCommitMode擾܂
     * @return AutoCommitModeLɂȂĂꍇtureԂ܂
     */
    public boolean getMode() {
        return mode;
    }
    
    /**
     * f[^x[Xڑ̃pX[h擾܂
     * @return f[^x[Xڑ̃pX[h
     */
    public String getPwd() {
        return pwd;
    }
    
    /**
     * SQL\[h擾܂
     * @return SQL\̏ꍇtrueԂ܂
     */
    public boolean getShowSql() {
        return showSql;
    }
    
    /**
     * RlNV^CAEg擾܂
     * @return RlNV^CAEgmsecŎ擾܂
     */
    public int getTimeout() {
        return timeout;
    }
    
    /**
     * f[^x[XڑURL擾܂
     * @return f[^x[XڑURL
     */
    public String getUrl() {
        return url;
    }
    
    /**
     * f[^x[Xڑ[U擾܂
     * @return f[^x[Xڑ[U
     */
    public String getUser() {
        return user;
    }
    
}

