/*
 * DomParser.java
 *
 * Created on 2007/12/04, 13:10
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.commons.document;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.itscool.commons.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/**
 * XML DOMc[̑NX
 * @author kanou
 */
public class DomParser {
    protected Document document;
    
    /**
     * ftHgRXgN^
     */
    public DomParser(){}
    
    /**
     * Ɏw肳ꂽDocumentCX^XDomParaserCX^X
     * ܂
     * @param document DocumentCX^X
     */
    public DomParser(Document document){
        this.document = document;
    }
    
    public Document getDocument(){
        return document;
    }
    
    /**
     * XML񂩂DocumentCX^XWJ܂
     * @param message XML
     * @param enc GR[h
     */
    public void parseText(String message, String enc) throws Exception{
        byte[] buf = message.getBytes(enc);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream bIn = new ByteArrayInputStream(buf);
        Document document = builder.parse( bIn  );
        
        this.document = document;
    }
    
    /**
     * pathŎw肳ꂽt@CDocumentCX^XWJ܂
     * @param path XMLt@C̃t@CpX
     * @param encode GR[h
     */
    public void parse(String path, String encode) throws Exception{
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        FileInputStream fin = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader(fin, encode);
        InputSource is = new InputSource();
        document = builder.parse(is);
        isr.close();
        fin.close();
    }
    
    /**
     * DomParserɓWJς݂DocumentCX^Xt@Cɏo͂܂
     * @param path t@C̏o͐
     * @param outEncode o͐̃GR[h
     */
    public void save(String path, String outEncode) throws Exception{
        FileOutputStream out = new FileOutputStream(path);
        OutputStreamWriter fw = new OutputStreamWriter(out, outEncode);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty(OutputKeys.ENCODING, outEncode);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(fw);
        transformer.transform(source, result);
        out.flush();
        out.close();
    }
    
    /**
     * WJς݂DocumentCX^XnodeNamesŎw肳ꂽ^OXg
     * Aŏ̂PԂ܂
     * @param nodeNames 擾^Oi^O̊Kw"."ŋ؂邱Ƃł܂jB
     *@iDocument[g̐΃pXw肵Ăj
     * @return Ỹ^ONodeCX^XŕԂ܂BY^OȂꍇ
     * nullԂ܂B
     */
    public Node getFirstElementsByTagNames(String nodeNames) throws Exception{
        //Document document = getDocument(message, enc);
        NodeList nodeList = document.getChildNodes();
        
        NodeList resultList = getElementsByTagNames(nodeList, nodeNames);
        if( resultList.getLength() == 0 ){
            return null;
        }else{
            return resultList.item(0);
        }
    }
    
    /**
     * WJς݂DocumentCX^Xw肳ꂽ^O^OXg擾܂
     * @param nodeName ^OiDocument[g̐΃pXw肵Ăj
     * @return ^Oɍv^Oꗗ
     */
    public NodeList getElementsByTagNames(String nodeNames) throws Exception{
        //Document document = getDocument(message, enc);
        NodeList nodeList = document.getChildNodes();
        
        return getElementsByTagNames(nodeList, nodeNames);
    }
    
    /**
     * nodeList̒AnodeNamesŎw肳ꂽŏ̃^ÕeLXg擾܂
     * @param nodeList NodeListCX^X
     * @param nodeName ^Oi^O̊Kw"."ŋ؂邱Ƃł܂jB
     * iNodeListCX^X̐΃pXŎw肵Ăj
     */
    public String getFirstTextElementByTagNames(NodeList nodeList, String nodeNames ) throws Exception{
        Node firstNode = getFirstElementsByTagNames(nodeList, nodeNames);
        NodeList childs = firstNode.getChildNodes();
        if( childs.getLength() == 0 ){
            return null;
        }else{
            return childs.item(0).getNodeValue();
        }
    }
    
    /**
     * nodeList̒AnodeNamesŎw肳ꂽŏ̃^O擾܂
     * @param nodeList NodeListCX^X
     * @param nodeName ^Oi^O̊Kw"."ŋ؂邱Ƃł܂jB
     * iNodeListCX^X̐΃pXŎw肵Ăj
     * @return nodeList̒nodeNamesɍv^OԂ܂
     */
    public Node getFirstElementsByTagNames(NodeList nodeList, String nodeNames ) throws Exception{
        NodeList resultNodeList = getElementsByTagNames(nodeList, nodeNames);
        if( resultNodeList.getLength() == 0 ){
            return null;
        }else{
            return resultNodeList.item(0);
        }
    }
    
    /**
     * nodeList̒AnodeNamesŎw肳ꂽ^Öꗗ擾܂
     * @param nodeList NodeListCX^X
     * @param nodeName ^Oi^O̊Kw"."ŋ؂邱Ƃł܂jB
     * iNodeListCX^X̐΃pXŎw肵Ăj
     * @return nodeList̒nodeNamesɍv^ÖꗗԂ܂
     */
    public NodeList getElementsByTagNames(NodeList nodeList, String nodeNames ) throws Exception{
        List tagNameList = StringUtil.split(nodeNames, ".");
        Node parentDummyNode = document.createElement("RESULT_TEMP_NODE");
        
        for( int i=0; i<nodeList.getLength(); i++){
            Node node = nodeList.item(i);
            if( tagNameList.size() == 0 ){
                return null;
            }else if( !node.getNodeName().equals((String)tagNameList.get(0))){
                continue;
            }else if( tagNameList.size() == 1 ){
                //resultNodeList.add(node);
                parentDummyNode.appendChild(node);
                
                continue;
            }else{
                NodeList childNodeList = node.getChildNodes();
                createNodeListByTagNames(parentDummyNode, tagNameList, childNodeList, 1);
            }
        }
        return parentDummyNode.getChildNodes();
    }
    
    protected void createNodeListByTagNames(Node parentDummyNode, List tagNameList, NodeList nodeList, int nodeFloor){
        int nodeNum = nodeList.getLength();
        for(int i=0; i<nodeNum; i++){
            Node childNode = nodeList.item(i);
            String checkNodeName = (String)tagNameList.get(nodeFloor);
            String childNodeName = childNode.getNodeName();
            if( checkNodeName.equals(childNodeName)){
                if( (nodeFloor+1) == tagNameList.size() ){
                    parentDummyNode.appendChild(childNode.cloneNode(true));
                }else{
                    NodeList magoNodeList = childNode.getChildNodes();
                    createNodeListByTagNames(parentDummyNode, tagNameList, magoNodeList, (nodeFloor + 1) );
                }
            }
        }
    }
}
