/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.controller;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.collection.InitParamMap;
import org.itscool.commons.util.FileUtil;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.controller.HtmlLayoutServlet;
import org.itscool.stylist.controller.RequestDispatchException;
import org.itscool.stylist.controller.RequestDispatcher;
import org.itscool.stylist.el.LayoutRegex;
import org.itscool.stylist.io.HtmlConfigReader;
import org.itscool.stylist.io.HtmlConverter;
import org.itscool.stylist.tag.HtmlRootTag;

public class HtmlLayoutServlet4x
extends HtmlLayoutServlet {
    protected void process(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = this.context.getRealPath(req.getServletPath());
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        if (encode == null) {
            this.log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        HtmlRootTag html = (HtmlRootTag)this.cacheMap.get(path);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        if (html == null || html.getLastModified() != FileUtil.getLastModified((String)path)) {
            html = new HtmlRootTag(encode);
            reader.create(path, html);
            this.cacheMap.put(path, html);
            this.log.trace("HtmlTag instance is created");
        } else {
            this.log.trace("HtmlTag instance geted from chache");
        }
        this.log.trace(html.toString(0, ""));
        HtmlConverter converter = new HtmlConverter();
        converter.init(this.context, req);
        String convStr = html.getXml() + System.getProperty("line.separator");
        convStr = convStr + html.getDtd() + System.getProperty("line.separator");
        convStr = convStr + converter.convert(html);
        convStr = new String(convStr);
        LayoutRegex regex = new LayoutRegex(this.context, req);
        convStr = regex.replacePath(convStr);
        String servletPath = req.getServletPath();
        String layoutPath = this.layout(servletPath, req);
        if (layoutPath != null) {
            TagInfo body = TagUtil.createTagInfo((String)convStr, (String)"body");
            TagInfo head = TagUtil.createTagInfo((String)convStr, (String)"head");
            if (body != null) {
                req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)body.getDataInTag());
                if (head != null) {
                    req.setAttribute("org.itscool.stylist.include.INCLUDE.head", (Object)head.getDataInTag());
                }
            } else {
                req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)convStr);
            }
            String contextPath = req.getServerName();
            int port = req.getServerPort();
            HtmlRootTag layoutTag = new HtmlRootTag(encode);
            HtmlConfigReader layoutReader = new HtmlConfigReader();
            layoutReader.setDefaultEncode(encode);
            layoutReader.create(layoutPath, layoutTag);
            convStr = converter.convert(layoutTag);
            if (body != null) {
                String bodyTagStr = body.getStartTag();
                Pattern pattern = Pattern.compile("<body>");
                Matcher matcher = pattern.matcher(convStr);
                convStr = matcher.replaceAll(body.getStartTag());
            }
        }
        res.setContentType("text/html; charset=" + encode);
        PrintWriter writer = res.getWriter();
        writer.write(convStr);
        writer.flush();
        writer.close();
    }

    protected String layout(String path, HttpServletRequest req) throws IOException, ServletException {
        String reqPath = this.context.getRealPath(req.getServletPath());
        RequestDispatcher dispatch = new RequestDispatcher(reqPath);
        String layoutPath = dispatch.getTemplatePath("layout");
        if (layoutPath == null) {
            this.log.trace("[NOT FOUND LAYOUT(" + reqPath + ")]");
            String layoutName = super.layout(path, req);
            layoutPath = this.context.getRealPath(layoutName);
            return layoutPath;
        }
        this.log.trace("[FOUND LAYOUT(" + reqPath + ")]" + layoutPath);
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        if (encode == null) {
            this.log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        HtmlRootTag layoutTag = (HtmlRootTag)this.cacheMap.get(layoutPath);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        if (layoutTag == null || layoutTag.getLastModified() != FileUtil.getLastModified((String)layoutPath)) {
            layoutTag = new HtmlRootTag(encode);
            File file = new File(layoutPath);
            if (!file.isFile()) {
                throw new RequestDispatchException("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb[" + layoutPath + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
            }
            reader.create(layoutPath, layoutTag);
            this.log.trace(layoutTag.toString(0, ""));
            this.cacheMap.put(layoutPath, layoutTag);
            this.log.trace("HtmlTag(layout) instance is created");
        } else {
            this.log.trace("HtmlTag(layout) instance geted from chache");
        }
        Object[] templates = dispatch.parseLayoutTag(layoutTag);
        for (int i = 0; i < templates.length; ++i) {
            String template = (String)templates[i];
            if (template.equals("body") || template.equals("head")) continue;
            this.setIncludeContents(dispatch, template, req);
        }
        return layoutPath;
    }

    protected void setIncludeContents(RequestDispatcher dispatch, String attrName, HttpServletRequest req) throws IOException {
        String layoutPath = dispatch.getTemplatePath(attrName);
        if (layoutPath == null) {
            req.setAttribute("org.itscool.stylist.include.INCLUDE." + attrName, (Object)("[NOTFOUND LAYOUT PARTS FILE" + attrName + "]" + layoutPath));
            this.log.trace("[NOTFOUND LAYOUT" + attrName + "]" + layoutPath);
            return;
        }
        this.log.trace("[FOUND LAYOUT " + attrName + "]" + layoutPath);
        String contextPath = req.getServerName();
        int port = req.getServerPort();
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        if (encode == null) {
            this.log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        HtmlRootTag layoutTag = (HtmlRootTag)this.cacheMap.get(layoutPath);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        if (layoutTag == null || layoutTag.getLastModified() != FileUtil.getLastModified((String)layoutPath)) {
            layoutTag = new HtmlRootTag(encode);
            File file = new File(layoutPath);
            if (!file.isFile()) {
                throw new RequestDispatchException("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb[" + layoutPath + "]\u3000\u5c5e\u6027[" + attrName + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
            }
            reader.create(layoutPath, layoutTag);
            this.cacheMap.put(layoutPath, layoutTag);
            this.log.trace("HtmlTag(layout) instance is created");
        } else {
            this.log.trace("HtmlTag(layout) instance geted from chache");
        }
        HtmlConverter converter = new HtmlConverter();
        converter.init(this.context, req);
        String convStr = converter.convert(layoutTag);
        LayoutRegex regex = new LayoutRegex(this.context, req);
        convStr = regex.replacePath(convStr);
        convStr = regex.replaceEl(convStr);
        TagInfo body = TagUtil.createTagInfo((String)convStr, (String)"body");
        if (body != null) {
            req.setAttribute("org.itscool.stylist.include.INCLUDE." + attrName, (Object)body.getDataInTag());
        } else {
            req.setAttribute("org.itscool.stylist.include.INCLUDE." + attrName, (Object)convStr);
        }
    }
}

