#!/usr/bin/perl

use strict;
use warnings;

$| = 1;

my $basedir = './dwfiles/';
#my $indexfile = 'indexdb.csv';
my $datafile = './addrs.ini';
my $htmlhead = <<_EOF_;
Content-Type: text/html;charset=UTF-8

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>deskwatcher QuickWatch mode</title>
<meta http-equiv="Refresh" content="60">
<script type="text/javascript" src="highslide.js"></script>
<script type="text/javascript">

// remove the registerOverlay call to disable the controlbar
hs.registerOverlay({
	thumbnailId: null,
	overlayId: 'controlbar',
	position: 'top right',
	hideOnMouseOut: true
});

hs.graphicsDir = './highslide/graphics/';
hs.outlineType = 'rounded-white';
// Tell Highslide to use the thumbnail's title for captions
hs.captionEval = 'this.thumb.title';


</script>
<style type="text/css">
* {
    font-family: Verdana, Helvetica;
    font-size: 10pt;
}
.highslide {
	cursor: url(highslide/graphics/zoomin.cur), pointer;
    outline: none;
}
.highslide-active-anchor img {
	visibility: hidden;
}
.highslide img {
	border: 2px solid gray;
}
.highslide:hover img {
	border: 2px solid white;
}

.highslide-wrapper {
	background: white;
}
.highslide-image {
    border: 2px solid white;
}
.highslide-image-blur {
}
.highslide-caption {
    display: none;
    
    border: 2px solid white;
    border-top: none;
    font-family: Verdana, Helvetica;
    font-size: 10pt;
    padding: 5px;
    background-color: white;
}
.highslide-loading {
    display: block;
	color: black;
	font-size: 8pt;
	font-family: sans-serif;
	font-weight: bold;
    text-decoration: none;
	padding: 2px;
	border: 1px solid black;
    background-color: white;
    
    padding-left: 22px;
    background-image: url(highslide/graphics/loader.white.gif);
    background-repeat: no-repeat;
    background-position: 3px 1px;
}
a.highslide-credits,
a.highslide-credits i {
    padding: 2px;
    color: silver;
    text-decoration: none;
	font-size: 10px;
}
a.highslide-credits:hover,
a.highslide-credits:hover i {
    color: white;
    background-color: gray;
}

.highslide-move {
    cursor: move;
}

.highslide-overlay {
	display: none;
}

a.highslide-full-expand {
	background: url(highslide/graphics/fullexpand.gif) no-repeat;
	display: block;
	margin: 0 10px 10px 0;
	width: 34px;
	height: 34px;
}


/* Controlbar example */
.controlbar {	
	background: url(highslide/graphics/controlbar4.gif);
	width: 167px;
	height: 34px;
}
.controlbar a {	
	display: block;
	float: left;
	/*margin: 0px 0 0 4px;*/	
	height: 27px;
}
.controlbar a:hover {
	background-image: url(highslide/graphics/controlbar4-hover.gif);
}
.controlbar .previous {
	width: 50px;
}
.controlbar .next {
	width: 40px;
	background-position: -50px 0;
}
.controlbar .highslide-move {
	width: 40px;
	background-position: -90px 0;
}
.controlbar .close {
	width: 36px;
	background-position: -130px 0;
}


/* Necessary for functionality */
.highslide-display-block {
    display: block;
}
.highslide-display-none {
    display: none;
}
</style>
</head>
<body>
_EOF_

# まず
#

print $htmlhead;
print <<_END_;
<h1>deskwatcher QuickWatch mode</h1>
<div id="controlbar" class="highslide-overlay controlbar">
	<a href="#" class="previous" onclick="return hs.previous(this)" title="Previous (left arrow key)"></a>
	<a href="#" class="next" onclick="return hs.next(this)" title="Next (right arrow key)"></a>
    <a href="#" class="highslide-move" onclick="return false" title="Click and drag to move"></a>
    <a href="#" class="close" onclick="return hs.close(this)" title="Close"></a>

</div>
</div>
_END_

&read;

print "</body>\n";

sub read {
open( FH,"< $datafile");
my @pcs = <FH>;
chomp(@pcs);

print "<table><tr>";

    my $cnt=1;
foreach my $pc(@pcs) {
    my $metafile = $basedir.'meta'.$pc.'.txt';
    if (0 == ($cnt % 3)) {
        print "</tr><tr>";
#    } elsif (0 == ($cnt % 3)) {
 #       print "</tr><tr>";
    }
    if (-e $metafile) {
        my @filetime = stat($metafile);
        if (time() < ((@filetime[9]) + 900)) {
            open(PFH, "< ".$metafile);
            my $mpc = <PFH>;
            my ($ipaddr,$date) = (split(/\,/,$mpc));
            my $hostname = gethostbyaddr(pack("C4", split(/\./, $ipaddr)),2);
            &picture("thumb$ipaddr.png","$ipaddr.png","$date ; $hostname ($ipaddr)");
            close(PFH);
        } else {
            print "<td><img src=\"".$basedir."na.png\" alt=\"$pc\" title=\"$pc\"></td>\n";
        }
    } else {
        print "<td><img src=\"".$basedir."na.png\" alt=\"$pc\" title=\"$pc\"></td>\n";
    }
    $cnt++
}
close(FH);
}

print "</table>";

sub picture {
    #my @date = split(/_/, $_[1]);
    #$date[5] = substr($date[5],0,-4);
    #print "<a id=\"$_[0]\" href=\"$basedir$_[1]\" class=\"highslide\" onclick=\"return hs.expand(this)\"><img src=\"$basedir$_[0]\" alt=\"$_[2]\" title=\"$date[0]/$date[1]/$date[2] $date[3]:$date[4]:$date[5]\"></a>\n";
    print "<td><a id=\"$_[0]\" href=\"$basedir$_[1]\" class=\"highslide\" onclick=\"return hs.expand(this)\"><img src=\"$basedir$_[0]\" alt=\"$_[2]\" title=\"$_[2]\"></a></td>\n";
}
