/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.web.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LocaleFilter
implements Filter {
    private String langParameter = "lang";
    private String[] acceptableLanguages = new String[]{"en", "ja"};
    private String defaultLanguage = "en";
    private String defaultContentType = "text/html;charset=UTF-8";

    public final void setLangParameter(String langParameter) {
        this.langParameter = langParameter;
    }

    public final void setAcceptableLanguages(String[] acceptableLanguages) {
        this.acceptableLanguages = acceptableLanguages;
    }

    public final void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public final void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((HttpServletRequest)request).getSession();
        Locale headerLocale = request.getLocale();
        String appLang = this.defaultLanguage;
        if (request.getParameterMap().containsKey(this.langParameter)) {
            appLang = request.getParameter(this.langParameter);
            if (Arrays.asList(this.acceptableLanguages).contains(appLang)) {
                session.setAttribute(this.langParameter, (Object)appLang);
            } else {
                appLang = this.defaultLanguage;
                session.setAttribute(this.langParameter, (Object)appLang);
            }
        } else if (session.getAttribute(this.langParameter) != null) {
            appLang = (String)session.getAttribute(this.langParameter);
        } else if (headerLocale != null) {
            appLang = headerLocale.getLanguage();
            if (!Arrays.asList(this.acceptableLanguages).contains(appLang)) {
                appLang = this.defaultLanguage;
            }
        } else {
            appLang = this.defaultLanguage;
        }
        Locale appLocale = new Locale(appLang);
        response.setLocale(appLocale);
        response.setContentType(this.defaultContentType);
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)appLocale);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

