/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import java.util.Date;

/**
 * Searchable Interface
 *
 * @author Yomei Komiya
 * @since 0.9.0
 *
 * @version $Id$
 */
public interface Searchable extends SearchableMetaData {
	
	/**
	 * @return Title for Search Result List
	 */
	public String getTitle();
	
	/**
	 * @param title
	 */
	public void setTitle(String title);
	
	/**
	 * @return Local Identifier
	 */
	public String getLocalIdentifier();
	
	/**
	 * @param localIdentifier
	 */
	public void setLocalIdentifier(String localIdentifier);
	
	/**
	 * @return Creator Name
	 */
	public String getCreator();
	
	/**
	 * @param creator
	 */
	public void setCreator(String creator);

	/**
	 * @return Date
	 */
	public Date getDate();
	
	/**
	 * @param date
	 */
	public void setDate(Date date);
	
	/**
	 * @return Document Content for Search
	 */
	public String getContent();
	
	/**
	 * @param content
	 */
	public void setContent(String content);
	
	/**
	 * Build Document Identifier
	 */
	public void buildIdentifier();

}
