/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

/**
 * Searchable Meta Data Entity
 *
 * @author Yomei Komiya
 * @since 0.9.0
 *
 * @version $Id$
 */
abstract public class SearchableMetaDataEntity implements Searchable {
	
	/**
	 * Document Contributor
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String contributor = null;
	
	/**
	 * Coverage
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String coverage = null;
	
	/**
	 * Document Format
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String format = null;
	
	/**
	 * Language
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String language = null;
	
	/**
	 * Publisher
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String publisher = null;
	
	/**
	 * Document Relation
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String relation = null;
	
	/**
	 * Document Type
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String type = null;
	
	/**
	 * Document Copyrights
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String rights = null;
	
	/**
	 * Document Global Identifier (e.g. URI, ISBN ...)
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String identifier = null;

	// for Meta Search
	/**
	 * Search Provider
	 */
	private String provider = null;
	
	/**
	 * Search Provider URL
	 */
	private String providerUrl = null;

	/**
	 * Compass Resource Alias
	 */
	private String resourceAlias = null;
	
	/**
	 * Document Resource Context
	 */
	private String resourceContext = null;
	
	/**
	 * Content Size
	 */
	private long size = 0;

	/**
	 * Search Score
	 */
	private float score = 0;
	
	/**
	 * Matched Text Fragment
	 */
	private String fragment = null;

	
	public SearchableMetaDataEntity() {
		super();
	}

	
	public final String getProvider() {
		return provider;
	}


	public final void setProvider(String provider) {
		this.provider = provider;
	}


	public final String getProviderUrl() {
		return providerUrl;
	}


	public final void setProviderUrl(String providerUrl) {
		this.providerUrl = providerUrl;
	}


	final public String getResourceAlias() {
		return resourceAlias;
	}


	final public void setResourceAlias(String resourceAlias) {
		this.resourceAlias = resourceAlias;
	}


	final public String getResourceContext() {
		return this.resourceContext;
	}
	
	
	final public void setResourceContext(String resourceContext) {
		this.resourceContext = resourceContext;
	}

	
	final public String getIdentifier() {
		return identifier;
	}


	final public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	
	public final String getContributor() {
		return contributor;
	}


	public final void setContributor(String contributor) {
		this.contributor = contributor;
	}


	public final String getCoverage() {
		return coverage;
	}


	public final void setCoverage(String coverage) {
		this.coverage = coverage;
	}


	public final String getFormat() {
		return format;
	}


	public final void setFormat(String format) {
		this.format = format;
	}


	public final String getLanguage() {
		return language;
	}


	public final void setLanguage(String language) {
		this.language = language;
	}


	public final String getPublisher() {
		return publisher;
	}


	public final void setPublisher(String publisher) {
		this.publisher = publisher;
	}


	public final String getRelation() {
		return relation;
	}


	public final void setRelation(String relation) {
		this.relation = relation;
	}


	public final String getType() {
		return type;
	}


	public final void setType(String type) {
		this.type = type;
	}


	public final String getRights() {
		return rights;
	}


	public final void setRights(String rights) {
		this.rights = rights;
	}


	public final long getSize() {
		return size;
	}


	public final void setSize(long size) {
		this.size = size;
	}


	final public float getScore() {
		return score;
	}

	
	final public void setScore(float score) {
		this.score = score;
	}


	final public String getFragment() {
		return fragment;
	}


	final public void setFragment(String fragment) {
		this.fragment = fragment;
	}
	
}
