/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.springframework.seasar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

/**
 * Seasar2ContainerFactory
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class Seasar2ContainerFactory {
	
	protected final Log logger = LogFactory.getLog(getClass());

	/**
	 * Seasar2 DI Configuration file path
	 */
	private String diconPath;
	
	
	public Seasar2ContainerFactory() {
		super();
	}

	
	/**
	 * Create Seasar2 Container Object
	 * 
	 * @return Seasar2 Container Object
	 * @throws SeasarException 
	 */
	public S2Container createS2Container() throws SeasarException {
		S2Container container = S2ContainerFactory.create(this.diconPath);
		
		try {
			container.init();
		}
		catch (RuntimeException re) {
			throw re;
		}
		catch (Exception e) {
			logger.error("Why does S2Container throw a generic checked exception, after all?", e);
			throw new SeasarException(e.getMessage());
		}
		
		return container;
	}


	public void setDiconPath(String diconPath) {
		this.diconPath = diconPath;
	}
	
}
