/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.compass.gps.fs;

import java.io.File;
import jp.sourceforge.webframe.compass.entity.TextFileSearchable;
import jp.sourceforge.webframe.compass.gps.fs.AbstractFileGpsDevice;
import jp.sourceforge.webframe.compass.gps.fs.FileGpsDeviceException;
import org.compass.core.CompassSession;
import org.compass.gps.CompassGpsException;

public class TextFileGpsDevice
extends AbstractFileGpsDevice {
    private String fileEncoding = "UTF8";
    private int maxFileSize = 1024;
    private String textFileSearchableClass;

    protected void doStart() throws CompassGpsException {
        super.doStart();
        if (this.fileEncoding == null || this.fileEncoding.equals("")) {
            throw new IllegalArgumentException(this.buildMessage("Must set fileEncoding property"));
        }
    }

    protected void doIndex(CompassSession session) throws CompassGpsException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Indexing the files in [" + this.getDirectory() + "]"));
        }
        try {
            File[] files = this.getFiles();
            Class<?> clazz = Class.forName(this.getTextFileSearchableClass());
            TextFileSearchable fileEntity = (TextFileSearchable)clazz.newInstance();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    fileEntity.loadFile(file, this.fileEncoding, this.maxFileSize);
                    session.create((Object)fileEntity);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new FileGpsDeviceException("Failed to index the files in [" + this.getDirectory() + "]", e);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Finished indexing the files"));
        }
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public String getTextFileSearchableClass() {
        return this.textFileSearchableClass;
    }

    public void setTextFileSearchableClass(String textFileSearchableClass) {
        this.textFileSearchableClass = textFileSearchableClass;
    }
}

