/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.springframework.compass;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfiguration;

public class CompassFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String senHome = null;
    private String configLocation = "";

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setSenHome(String senHome) {
        this.senHome = senHome;
    }

    public Compass createCompass() throws CompassException {
        if (this.senHome != null) {
            System.setProperty("sen.home", this.senHome);
        }
        try {
            CompassConfiguration config = new CompassConfiguration();
            config.configure(this.configLocation);
            return config.buildCompass();
        }
        catch (CompassException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            this.logger.error((Object)"Why does Compass throw a generic checked exception, after all?", (Throwable)e);
            throw new CompassException(e.getMessage());
        }
    }
}

