/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import jp.sourceforge.webframe.ws.search.Hit;

/**
 * SearchableHit
 * Container for Web Service's Hit Type
 *
 * @author Yomei Komiya
 * @since 0.9.0
 *
 * @deprecated Use jp.sourceforge.metasearch.compass.entity.SearchableHit
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id$
 */
public class SearchableHit extends SearchableGenericEntity {

	public SearchableHit() {
		super();
	}

	
	public SearchableHit(Hit hit) {
		super();

		this.setIdentifier(hit.getIdentifier());
		this.setTitle(hit.getTitle());
		this.setCreator(hit.getCreator());
		this.setDate(hit.getDate());
		this.setType(hit.getType());
		this.setRights(hit.getRights());
		
		this.setProvider(hit.getProvider());
		this.setProviderUrl(hit.getProviderUrl());
		this.setSize(hit.getSize());
		this.setScore(hit.getScore());
		this.setFragment(hit.getFragment());
	}

	
	public void buildIdentifier() {
		// Dummy
	}

}
