/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.io;

import java.io.File;

/**
 * FileScanner interface
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id$
 */
public interface FileScanner {

	/**
	 * Scan file
	 * 
	 * @param filePath File path
	 * @param fileEncodingCharset File encoding charset name
	 * @throws ScanAbortException
	 */
	public abstract void scan(String filePath, String fileEncodingCharset)
			throws ScanAbortException;

	/**
	 * Scan file
	 * 
	 * @param file File object
	 * @param fileEncodingCharset File encoding charset name
	 * @throws ScanAbortException
	 */
	public abstract void scan(File file, String fileEncodingCharset)
			throws ScanAbortException;

}