/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass;

import org.compass.core.Compass;

import jp.sourceforge.webframe.blankapp.test.AbstractWebframeDiSpringContextTests;

/**
 * CompassContextTest
 *
 * @author Yomei Komiya
 *
 * @version $Id$
 */
public class CompassContextTest extends
		AbstractWebframeDiSpringContextTests {

	private CompassContext compassContext = null;
	

	public void setCompassContext(CompassContext compassContext) {
		this.compassContext = compassContext;
	}


	protected void onSetUp() throws Exception {
		super.onSetUp();
	}

	
	protected void onTearDown() throws Exception {
		super.onTearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.CompassContext.getCompass()' test method
	 */
	public void testGetCompass() {
		// 1. Sen Home Test
		this.compassContext.setSenHome(null);
		Compass compass = this.compassContext.getCompass();
		assertNull(System.getProperty("sen.home"));
		
		this.compassContext.setCompass(null);
		this.compassContext.setSenHome("/usr/local/sen-1.2.2.1");
		compass = this.compassContext.getCompass();
		assertEquals(
				"/usr/local/sen-1.2.2.1",
				System.getProperty("sen.home"));
		
		// 2. Compass object test
		this.compassContext.setCompass(null);
		compass = this.compassContext.getCompass();
		assertTrue(compass instanceof Compass);
		
		this.compassContext.setCompass(compass);
		Compass actualCompass = this.compassContext.getCompass();
		assertEquals(compass, actualCompass);
		this.compassContext.setCompass(null);
	}

}
