/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.io;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.webframe.io.LineMalformedException;
import jp.sourceforge.webframe.io.LineParser;
import org.apache.commons.collections.map.TypedMap;
import org.apache.commons.lang.StringUtils;

public class DefaultCsvLineParser
implements LineParser {
    private String delim;
    private String[] itemNames;

    public DefaultCsvLineParser() {
    }

    public DefaultCsvLineParser(String delim, String[] itemNames) {
        this.delim = delim;
        this.itemNames = itemNames;
    }

    public Map parse(String line) throws LineMalformedException {
        String[] parsedItems = StringUtils.splitPreserveAllTokens((String)line, (String)this.delim);
        if (parsedItems.length == this.itemNames.length) {
            Map map = TypedMap.decorate(new HashMap(), String.class, String.class);
            int i = 0;
            while (i < this.itemNames.length) {
                map.put(this.itemNames[i], parsedItems[i]);
                ++i;
            }
            return map;
        }
        throw new LineMalformedException("Expected format: <" + StringUtils.join((Object[])this.itemNames, (String)this.delim) + ">(" + this.itemNames.length + ") but was: <" + line + ">(" + parsedItems.length + ")");
    }

    public String getDelim() {
        return this.delim;
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public String[] getItemNames() {
        return this.itemNames;
    }

    public void setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
    }
}

