/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.io;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.webframe.io.DefaultCsvLineParser;
import jp.sourceforge.webframe.io.LineMalformedException;
import junit.framework.TestCase;

public class DefaultCsvLineParserTest
extends TestCase {
    private DefaultCsvLineParser parser = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = new DefaultCsvLineParser();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.parser = null;
    }

    public void testParse() throws Exception {
        String csvLine = "This:is:CSV:line:string.";
        String delim = ":";
        String[] itemNames = new String[]{"first", "second", "third", "fourth", "fifth"};
        this.parser.setDelim(delim);
        this.parser.setItemNames(itemNames);
        Map actual = this.parser.parse(csvLine);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("first", "This");
        expected.put("second", "is");
        expected.put("third", "CSV");
        expected.put("fourth", "line");
        expected.put("fifth", "string.");
        DefaultCsvLineParserTest.assertEquals(expected, (Object)actual);
        try {
            String malFormedLine = "This:is:invalid:CSV:line:string.";
            actual = this.parser.parse(malFormedLine);
            DefaultCsvLineParserTest.fail((String)"Test failed.");
        }
        catch (LineMalformedException e) {
            System.out.println(e.getMessage());
        }
    }
}

