/*
 * $Id: WebpubTestPlugin.java,v 1.8 2004/04/26 06:46:07 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import java.io.*;
import java.net.URL;
import java.util.regex.Pattern;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.swt.widgets.Display;

import com.narucy.webpub.core.*;

/**
 * WebpubTestPlugin provides utilities methods.
 */
public class WebpubTestPlugin extends Plugin {

	final public static String ID_PLUGIN = "com.narucy.webpub.test";
	
	static WebpubTestPlugin plugin;
	
	public WebpubTestPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
	}
	
	public static WebpubTestPlugin getDefault(){
		return plugin;
	}

	public static String getLocalPath(String path){
		try{
			URL url = Platform.asLocalURL( plugin.find(new Path(path)) );
			return new File(url.getFile()).toString();
		}catch(IOException e){
			WebpubPlugin.handleException(e);
		}
		return null;
	}

	public static void forceDelete(IProject proj) {
		Display display = Display.getCurrent();
		while(proj.exists()){
			while(display.readAndDispatch()){
				
			}
			System.gc();
			try {
				IProjectDescription projDesc = proj.getDescription();
				projDesc.setNatureIds(new String[]{});
				proj.setDescription(projDesc, null);
				
				proj.delete(true, null);
			}catch (CoreException e) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e1) {
				}
			}
		}
	}

	public static WebProject createTestProject(String originalProjectPath) throws CoreException {
		return createTestProject( new File(getLocalPath(originalProjectPath)) );
	}
	
	public static WebProject createTestProject(final File originalProjetDirectory) throws CoreException{
		final WebProject[] wp = {null};
		ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable() {
			public void run(IProgressMonitor monitor) throws CoreException {
				wp[0] = internalCreateTestProject(originalProjetDirectory);
			}
		}, null);
		return wp[0];
	}

	static WebProject internalCreateTestProject(File originalProjetDirectory) throws CoreException{
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = workspace.getRoot();
		
		String name = originalProjetDirectory.getName();
		
		IProject proj = root.getProject(name);
		IProjectDescription desc = workspace.newProjectDescription(name);
		proj.create(desc, null);
		proj.open(null);
		
		try {
			FileUtilities.copyWithDir(
				originalProjetDirectory,
				root.getLocation().toFile(),
				new Pattern[]{Pattern.compile("^CVS$")});
			
		} catch (IOException e) {
			throw new CoreException(new Status(
				IStatus.ERROR,
				WebpubTestPlugin.ID_PLUGIN,
				IStatus.OK,
				"occasion in doing copy test project files",
				e));
		}
		root.refreshLocal(IResource.DEPTH_INFINITE, null);
		
		proj.close(null);
		proj.open(null);
		
		WebProject wp = (WebProject)proj.getNature(WebProject.ID_NATURE);
		if(wp == null){
			throw new IllegalArgumentException("specified project is not web project");
		}
		
		wp.load();
		proj.build(IncrementalProjectBuilder.FULL_BUILD, null);
		
		return wp;
	}
	
	public static File createTempFile(String suffix) throws IOException{
		return File.createTempFile("com.narucy.webpub.core.tests", suffix);
	}

}
