/*
 * $Id: AmritaErrorHandlerTest.java,v 1.5 2004/04/20 06:57:04 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.publish;

import java.io.FileOutputStream;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;

import com.narucy.webpub.core.publish.PublisherBuilder;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 * <ul>
 * <li>no script file found in specify publish description
 * <li>no class file found
 * <li>ht parse error
 * <li>undefined method in member object defined script
 * </ul>
 */
public class AmritaErrorHandlerTest extends TestCase {

	IProject project;
	
	protected void setUp() throws Exception{
		project = WebpubTestPlugin.createTestProject("test_projects/ErrorHandling").getProject();
	}

	public void testCreateMarker() throws Exception {
		// script not found
		IMarker[] markers = project.getFile("ht_sources/amrita-noscript.html").findMarkers(null, false, IResource.DEPTH_ZERO);
		assertEquals(1, markers.length);
		assertEquals(PublisherBuilder.MARKER_MISSED_SRC, markers[0].getType());
		assertTrue(markers[0].getAttribute(IMarker.MESSAGE).toString()
			.indexOf("No such file to load") != -1);
		
		// class not found
		markers = project.getFile("ht_sources/amrita-noclass.html").findMarkers(null, false, IResource.DEPTH_ZERO);
		assertEquals(PublisherBuilder.MARKER_MISSED_SRC, markers[0].getType());
		assertEquals(1, markers.length);
		assertEquals(PublisherBuilder.MARKER_MISSED_SRC, markers[0].getType());
		assertTrue(markers[0].getAttribute(IMarker.MESSAGE).toString()
			.indexOf("uninitialized constant Webpub::AmritaPublisher::XXXPage") != -1);
		
		// parse error
		markers = project.getFile("ht_sources/amrita-parse_error.html").findMarkers(null, false, IResource.DEPTH_ZERO);
		assertEquals(1, markers.length);
		assertEquals(PublisherBuilder.MARKER_MISSED_SRC, markers[0].getType());
		assertEquals(2, markers[0].getAttribute(IMarker.LINE_NUMBER, -1));
		
		// undefined method error
		IFile htFile = project.getFile("ht_sources/amrita-undef_method.html");
		markers = htFile.findMarkers(null, false, IResource.DEPTH_ZERO);
		assertEquals(1, markers.length);
		assertEquals(PublisherBuilder.MARKER_MISSED_SRC, markers[0].getType());
		
		IFile scriptFile = project.getFile("scripts/undef_method.rb");
		markers = scriptFile.findMarkers(null, false, IResource.DEPTH_ZERO);
		assertEquals(1, markers.length);
		assertEquals( PublisherBuilder.MARKER_RUBY, markers[0].getType() );
		
		// delete marker
		new FileOutputStream(htFile.getLocation().toFile()).close();
		htFile.refreshLocal(IResource.DEPTH_ZERO, null);
		project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
		
		assertEquals(0, htFile.findMarkers(null, false, IResource.DEPTH_ZERO).length);
		assertEquals(0, scriptFile.findMarkers(null, false, IResource.DEPTH_ZERO).length);
	}

	protected void tearDown() throws Exception {
		WebpubTestPlugin.forceDelete(project);
	}

}
