/*
 * Created on 2004/03/29
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.narucy.webpub.core.tests.publish;

import java.io.*;
import java.util.Date;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.publish.PublishLogStore;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

public class PublishLogStoreTest extends TestCase {

	WebProject webProj;

	public PublishLogStoreTest(String name){
		super(name);
	}
	
	protected void setUp() throws Exception {
		PublishLogStore.clearAllLogs();
	}
	
	public void testDeleteExcessFiles() throws Exception {
		webProj = WebpubTestPlugin.createTestProject("test_projects/PublishLogStoreTest");
		IProject proj = webProj.getProject();
		
		PublishLogStore logStore = webProj.getLogStore();
		assertEquals(1, logStore.getLogDates().length);
		for(int i=0; i<4; i++){
			proj.getFile("ht_sources/am_page.html").touch(null);
			proj.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
		}
		Date[] ds = logStore.deleteExcessFiles();
		assertEquals(3, logStore.getLogDates().length);
	}
	
	public void testLog() throws Exception {
		webProj = WebpubTestPlugin.createTestProject("test_projects/PublishLogStoreTest");
		PublishLogStore logStore = webProj.getLogStore();
		
		IProject proj = webProj.getProject();

		Date[] logDates = logStore.getLogDates();
		assertEquals(1, logDates.length);
		
		File[] files = logStore.getLogFiles(logDates[0]);
		// error lines
		String[] ls = new TextReader(files[0].toURL()).toLines();
		assertEquals("ABCDEF", ls[0]);
		assertEquals("XYZZ", ls[1]);
		
		// unparsed lines
		ls = new TextReader(files[1].toURL()).toLines();
		assertEquals("abc", ls[0]);
		assertEquals("xy", ls[1]);

		// full publish
		proj.build(IncrementalProjectBuilder.FULL_BUILD, null);
		logDates = logStore.getLogDates();
		assertEquals(2, logDates.length);
		
		assertTrue(logDates[0].getTime() < logDates[1].getTime());
		
		ls = new TextReader(logStore.getLogFile(logDates[1], "stderr") .toURL()).toLines();
		assertEquals("ABCDEF", ls[0]);
		assertEquals("XYZZ", ls[1]);
		
		ls = new TextReader(logStore.getLogFile(logDates[1], "stdout") .toURL()).toLines();
		assertEquals("abc", ls[0]);
		assertEquals("xy", ls[1]);
	}
	
	String logFiles(){
		StringBuffer buff = new StringBuffer();
		File[] dirs = PublishLogStore.LOG_STORE_ROOT_DIRECTORY.listFiles();
		for (int i = 0; i < dirs.length; i++) {
			File[] files = dirs[i].listFiles();
			buff.append(dirs[i] + "\n");
			for (int j = 0; files != null && j < files.length; j++) {
				buff.append(files[j] + "\n");
			}
		}
		return buff.toString();
	}
	
	public void testGetLog() throws Exception {
		webProj = WebpubTestPlugin.createTestProject("test_scripts/webpub/test_workspace/web_project");
		
		PublishLogStore logStore = webProj.getLogStore();
		IProject proj = webProj.getProject();

		Date[] logDates = logStore.getLogDates();
		for (int i = 0; i < logDates.length; i++) {
			File[] files = logStore.getLogFiles(logDates[i]);
			for (int j = 0; j < files.length; j++) {
				assertTrue( files[j].exists() );
			}
			// stderr and unparsed lines.
			assertEquals(2, files.length);
			assertTrue( files[0].getName().indexOf(".stderr") != -1);
			assertTrue( files[1].getName().indexOf(".stdout") != -1);
		}
		assertEquals(logFiles(),
				1, logDates.length);
		
		// touch erb files
		IResource[] rs = proj.getFolder("erbs").members();
		for (int i = 0; i < rs.length; i++) {
			rs[i].touch(null);
		}
		proj.refreshLocal(IResource.DEPTH_INFINITE, null);
		proj.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
		
		logDates = logStore.getLogDates();
		assertEquals(2, logDates.length);
		
		// new file that print to standerd out.
		IFile newFile = proj.getFile("ht_sources/new.erb");
		
		PrintWriter writer = new PrintWriter(new FileOutputStream(newFile.getLocation().toFile()));
		TextReader r = new TextReader(getClass().getResource("stdout.erb"));
		while(r.hasNext()){
			writer.println(r.nextLine());
		}
		r.close();
		newFile.refreshLocal(IResource.DEPTH_ZERO, null);
		proj.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
		
		assertEquals(3, logStore.getLogDates().length);
	}

	protected void tearDown() throws Exception {
		IProject proj = webProj.getProject();
		
		IProjectDescription projDesc = proj.getDescription();
		projDesc.setNatureIds(new String[]{});
		proj.setDescription(projDesc, null);
		WebpubTestPlugin.forceDelete(proj);
	}

}
