#
# $Id: erb_publisher_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'fileutils'
require 'tempfile'
require 'webpub/publisher'
require 'webpub/publish_manager'

=begin

ERBPublisher is publish with erb.

Tests distribute simple erb script and

=end
class ERBPublisherTest < Test::Unit::TestCase

	include Webpub

	def setup
		@ws_path = Dir::tmpdir + '/workspace'
		FileUtils.cp_r(File.dirname(__FILE__) + '/test_workspace', @ws_path)
		
		EclipseWorkspace.instance.workspace_path = @ws_path
		PublisherRegistory.instance.regist_plugin(File.dirname(__FILE__) + '/../../../com.narucy.webpub.core/')
		
		@webproj_path = @ws_path + '/web_project'
	end

	def test_publish_by_erb
		mgr = PublishManager.new
		mgr.result_output = []
		
		files = Dir.glob(@webproj_path + '/erbs/**/*')
		oks, fails = mgr.publish(files)
		
		assert_equal(3, oks.size)
		assert_equal(1, fails.size)
		
		assert(3, mgr.result_output.select { |l| /^<<<OK/ === l }.size)
		assert(1, mgr.result_output.select { |l| /^<<<FAILED/ === l }.size)
		
		files = Dir.glob(@webproj_path + '/public_html/erbs/*').sort
		assert_equal(4, files.size)
		
		assert />4</ === IO.read(files[0]) # 2*2
		assert />6</ === IO.read(files[1]) # 2*3
		assert />msg27</ === IO.read(files[2]) #3**3
		assert /<body><h4><pre>undefined local variable or method `msg/ === IO.read(files[3])
	end

	def teardown
		FileUtils.rm_r(@ws_path)
	end

end
