#
# $Id: install_checker_manager_test.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'tempfile'
require 'webpub/install_checker'

=begin

InstallCheckerManager for easy to ruby libraries state notify to UI user.

=end
class InstallCheckerManager < Test::Unit::TestCase

	def create_check_mgr
		args = %w[
			amrita webpub/install_checker_items.rb Webpub::AmritaChecker
			rd webpub/install_checker_items.rb Webpub::RDChecker
			interpreter webpub/install_checker_items.rb Webpub::InterpreterChecker
		]
		Webpub::InstallCheckerManager::new_as_args(args)
	end

	def test_check
		mgr = create_check_mgr()
		assert_equal(3, mgr.do_check.size)
		
		file = File.join( Dir::tmpdir, 'checkertest')
		mgr.dist_result(file)
		lines = File.read(file)
		assert /^interpreter,.*0$/ === lines
		assert /^amrita,.*0$/ === lines
		assert /^rd,.*0$/ === lines
		
		ls = ''
		mgr.expand_result(ls)
		assert_equal(lines, ls)
	end

end
