#
# $Id: publish_manager_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'tmpdir'
require 'fileutils'
require 'webpub/publish_manager'

=begin

PublisherManager provides to invoke publish process and output publish
result message these are success or failed.

And cache plugin location.

=end
class PublisherManagerTest < Test::Unit::TestCase

	include Webpub

	class DummyPublisher1 < Webpub::Publisher
		def publish(req)
			$flag_PublisherManagerTest[1] = true
		end
	end

	module A
	module B
	module C
	class DummyPublisher2 < Webpub::Publisher
		def publish(req)
			$flag_PublisherManagerTest[2] = true
		end
	end
	end
	end
	end

	class DummyPublisher3 < Webpub::Publisher
		def publish(desc)
			raise "dummy error"
		end
	end

	def setup
		# init publisher registory
		@manager = PublishManager.new
		@manager.plugin_registory.clear
		
		@entries = [
			['dummy1', 'PublisherManagerTest::DummyPublisher1'],
			['dummy2', 'PublisherManagerTest::A::B::C::DummyPublisher2'],
			['dummy3', 'PublisherManagerTest::DummyPublisher3'],
		]
		@entries.each { |entry|
			id, class_name = *entry
			@manager.plugin_registory.regist(id, __FILE__, class_name)
		}
		# copy files
		@ws_path = Dir::tmpdir + '/workspace'
		FileUtils.cp_r(File.dirname(__FILE__) + '/test_workspace', @ws_path)
		@manager.workspace.workspace_path=(@ws_path)
		@proj_root = @ws_path + '/web_project'
		
		# init test values
		$flag_PublisherManagerTest = {}
		@manager.result_output = []
		
		FileUtils.rm(@manager.plugins_entry_filepath) if File.exist?(@manager.plugins_entry_filepath)
	end

	##
	# find web project in workspace and checks publish targets are included in same project.
	#
	def test_check_files
		err = nil
		assert_raise(ArgumentError) {
			@manager.check_files([
				@ws_path + "/aaa/x",
				@ws_path + "/bbb/x",
			])
		}
		assert_raise(ArgumentError){
			@manager.check_files([@ws_path + '/xxx/x'])
		}
		
		wp = @manager.check_files([
			@ws_path + '/web_project/rd/a.rd',
			@ws_path + '/web_project/rd/b.rd',
		])
		assert_equal('web_project', wp.name)
	end

	def test_cache_plugins
		@manager.store_plugins_entry
		assert( File.exist?(@manager.plugins_entry_filepath) )
		
		@manager.plugin_registory.clear
		assert(@manager.plugin_registory.ids.empty?)
		
		@manager.load_plugins_entry
		assert_equal(%w!dummy1 dummy2 dummy3!, @manager.plugin_registory.ids.sort)
		
		err = nil
		begin
			@manager.workspace.workspace_path=(nil)
			@manager.load_plugins_entry
		rescue PublisherEnvironmentException => err
		end
		assert(err)
	end

	##
	# Distribute no content html file that only publish property values
	# for a testing dummy publisher
	#
	def create_dummy(file_name, by)
		f = @proj_root + '/ht_sources/' + file_name
		open(f, 'w') { |fh|
			fh << %Q!<?publish by="#{by}"?>!
		}
		f
	end

	def test_invoke_publisher
		files = [ create_dummy('d1.htm', 'dummy1'), create_dummy('d2.htm', 'dummy2') ]
		
		@manager.publish(files, 'dummy1')
		assert $flag_PublisherManagerTest[1]
		assert_nil $flag_PublisherManagerTest[2]
		
		$flag_PublisherManagerTest.clear
		@manager.publish(files, 'dummy2')
		assert_nil $flag_PublisherManagerTest[1]
		assert $flag_PublisherManagerTest[2]
		
		$flag_PublisherManagerTest.clear
		ok_descs, failed_descs = @manager.publish(files)
		assert $flag_PublisherManagerTest[1]
		assert $flag_PublisherManagerTest[2]
		
		assert(%r!^<<<OK,.*d1.htm,dummy1,.*d1.htm,>>>$! === @manager.result_output[0])
		assert(%r!^<<<OK,.*d2.htm,dummy2,.*d2.htm,>>>$! === @manager.result_output[1])
		
		assert_equal(2, ok_descs.size)
		assert_equal(0, failed_descs.size)
	end

	def test_handle_error
		files = [ create_dummy('d3.htm', 'dummy3') ]
		
		@manager.result_output = []
		ok_descs, failed_descs = @manager.publish(files)
		
		result_entry = @manager.result_output
		assert_equal( 1, result_entry.size)
		
		assert(%r!^<<<FAILED,.*d3.htm,dummy3,.*d3.htm,! === result_entry[0])
		assert(%r!dummy error$! === result_entry[0])
		
		assert_equal(0, ok_descs.size)
		assert_equal(1, failed_descs.size)
	end

	def teardown
		$flag_PublisherManagerTest = nil
		FileUtils.rm_r(@ws_path)
		@manager.plugin_registory.clear
	end

end
