require 'test/unit'
require 'tempfile'
require 'rbconfig'
require 'fileutils'
require 'webpub/eclipse_workspace'
require 'webpub/publish_manager'

=begin

This test uses ENV['RUBY_PREFIX'] that is find path an interpreter file
for command line test. If not specified that environment value, to use
Config::CONFIG['prefix'] + /bin/ruby

wp.rb provides command line interface for publish files.
This interpreterWrapping to Webpub::PublishManager.

=end
class WPTest < Test::Unit::TestCase

	include Webpub

	@@test_projects_dir = File.dirname(File.expand_path(__FILE__)) + '/../test_projects'

	def setup
		@ws_path = Dir::tmpdir + '/workspace'
		FileUtils.cp_r( File.dirname(__FILE__) + '/webpub/test_workspace', @ws_path)
		EclipseWorkspace.instance.workspace_path = @ws_path
		
		prefix = ENV['RUBY_PREFIX'] || Config::CONFIG['prefix']
		bin_ruby = prefix + '/bin/ruby'
		
		@plugins_dir = File.expand_path(File.dirname(__FILE__) + '/../..')
		wp_cmd = @plugins_dir + '/com.narucy.webpub.core/scripts/bin/wp'
		@wp_cmd = "#{bin_ruby} #{wp_cmd}"
		
		@current_dir = Dir.pwd
	end

	def test_opt_e
		Tempfile.open('stderr') { |stderr|
			Dir.chdir(Dir::tmpdir)
			`#{@wp_cmd} -w#{@ws_path} -e#{stderr.path}`
			assert(/^not specified publish target file$/ === stderr.read)
		}
		
		Tempfile.open('stderr') { |stderr|
			Dir.chdir(@ws_path + '/web_project')
			`#{@wp_cmd} -w#{@ws_path} -e#{stderr.path}`
			assert(stderr.read.empty?)
		}
		
		Tempfile.open('stderr') { |stderr|
			proj_path = @ws_path + '/put_err_project'
			FileUtils.cp_r(@@test_projects_dir + '/PublishLogStoreTest/', proj_path)
			Dir.chdir(proj_path)
			
			lines = `#{@wp_cmd} -w#{@ws_path} -e#{stderr.path}`
			
			assert /^abc$/ === lines
			assert /^xy$/ === lines
			assert %r!^<<<OK,.+ht_sources/am_page.html,amrita! === lines
			assert %r!^<<<OK,.+ht_sources/erb_page.html,erb! === lines
			
			lines = stderr.read
			assert /^ABCDEF$/ === lines
			assert /^XYZZ$/ === lines
		}
	end

	def test_opt_t
		Tempfile.open('wp_test-publish_targets') { |publish_targets|
			Dir.glob(@ws_path + '/web_project/erbs/*.erb') { |f|
				publish_targets.puts(f)
			}
			publish_targets.flush
			result_lines = `#{@wp_cmd} -w#{@ws_path} -t#{publish_targets.path}`
			
			ok, failed = PublishManager::result_parser(result_lines)
			
			assert_equal(2, ok.size)
			assert File.exist?(ok[0][2])
			assert File.exist?(ok[1][2])
		}
	end
	
	def test_entry
		Tempfile.new('wp_test-plugin_entries') { |plugin_entries|
			reg = Webpub::PublisherRegistory.instance
			reg.clear
			reg.regist_plugin(File.dirname(__FILE__) + '/webpub/test_plugins/aaa')
			reg.store_publisher_entry_file(plugin_entries.path)
			plugin_entries.flush
			
			Dir.chdir(@ws_path + '/web_project')
			result = `#{@wp_cmd} -p#{tmpfile.path}`
			assert %r!<<<FAILED,.+/web_project/ht_sources/home.html! === result
		}
	end

	def test_help
		stdout = `#{@wp_cmd} -h`
		assert(/^usage: wp/ === stdout, stdout)
		assert(/^eclipse ide extend options:/ === stdout, stdout)
	end

	def test_abort
		stderr = `#{@wp_cmd} --abc 2>&1`
		assert(/usage: wp/ === stderr, stderr)
	end

	def test_env_error
		Dir.chdir(Dir::tmpdir)
		stderr = `#{@wp_cmd} -p#{@plugins_dir} 2>&1`
		assert(/^workspace directory is not specified/ === stderr, stderr)
		
		stderr = `#{@wp_cmd} -p#{@plugins_dir} -w#{@ws_path} 2>&1`
		assert /^not specified publish target file/ === stderr
	end
	
	def test_find_workspace
		Dir.chdir(@ws_path + '/web_project/scripts')
		stderr = `#{@wp_cmd} -p#{@plugins_dir} 2>&1`
		assert( /^not specified publish target file/ === stderr, stderr)
	end

	def test_publish_in_project_root
		Dir.chdir(Dir::tmpdir)
		proj_dir = @ws_path + '/web_project'
		Dir.chdir(proj_dir)
		
		lines = `#{@wp_cmd} -p#{@plugins_dir} -w#{@ws_path}`
		stdout = `#{@wp_cmd} -p#{@plugins_dir}`
		ok, failed = PublishManager::result_parser(lines)
		assert_equal(22, ok.size)
		
		ok.each { |entry|
			if entry[1] == 'null'
				assert !File.exist?(entry[2])
			else
				assert File.exist?(entry[2])
			end
		}
		
		erb_entry = failed.select { |v| 'erb' == v[1] }[0]
		assert(%r!erbs/c/a/c-a-b.erb$! === erb_entry[0])
		assert(%r!public_html/erbs/c-a-b.html$! === erb_entry[2])
		assert(/undefined local variable or method/ === erb_entry[3].join)
		
		failed.sort.each { |v|
			assert( File.exist?(v[0]))
			assert( File.exist?(v[2]), 'file is not exist:' + v[3].join)
		}
		assert_equal(4, failed.size)
	end
	
	def teardown
		Dir.chdir(@current_dir)
		FileUtils.rm_r(@ws_path)
	end

end
