#
# $Id: amrita_publisher.rb,v 1.5 2004/04/16 08:35:11 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'cgi'
require 'amrita/template'
require 'webpub/publisher'
require 'webpub/abstorel_filter'

module Webpub

class AmritaPublisher < Publisher

	include Amrita

	def publish(desc)
		begin
			do_publish(desc)
		rescue Exception => err
			open( desc.publish_to, 'w') { |fh|
				fh <<
					"<body><h4><pre>#{CGI.escapeHTML(err.message)}</pre></h4>" +
					%Q!<pre>#{CGI.escapeHTML(err.backtrace.join("\n"))}</pre>! +
					'</body>'
			}
			
			if err.class == Amrita::HtmlParseError
				raise err
			else
				raise err.class, err.message.gsub("\n", err.class.to_s), err.backtrace
			end
		end
	end
	
	protected
	
	def do_publish(desc)
		tmpl = create_template(desc)
		config_template(tmpl, desc)
		
		memberobj = create_memberobj(desc)
		
		lines = ''
		tmpl.expand(lines, memberobj)
		ht_distribute(desc, lines)
	end

	def create_memberobj(desc)
		prop = desc.arguments
		load File.join( desc.web_project[:scripts_dir], prop['script'])
		klass_name = prop['class']
		method = prop['method']
		
		if klass_name
			klass = eval(klass_name)
			member_obj = klass.instance_method(:initialize).arity != 0 ? klass.new(desc) : klass.new
			method ? member_obj.send(method) : member_obj
		elsif method
			eval(method)
		else
			raise "Invalid arguments by amrita (not specify both class and method):#{desc.inspect}"
		end
	end
	
	
	def create_template(desc)
		TemplateFile.new(desc.publish_from)
	end
	
	def config_template(tmpl, desc)
		args = desc.arguments
		if tmpl.respond_to?(:expand_attr=)
			opt = args['expand_attr']
			tmpl.expand_attr = opt ? eval(opt) : true
		end
		
		tmpl.xml = eval(args['xml']) if args['xml']
		tmpl.asxml = eval(args['asxml']) if args['asxml']
		tmpl.compact_space = eval(args['compact_space']) if tmpl.respond_to?(:compact_space=) and args['compact_space']
		tmpl.prettyprint = eval(['prettyprint']) if tmpl.respond_to?(:prettyprint=) and args['prettyprint']
		tmpl
	end
	
end

end
