#
# $Id: rd_checker.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/install_checker'

module Webpub

class InterpreterChecker < InstallChecker

	def check
		if VERSION.to_f < 1.8
			return 'Ruby must be version 1.8 or later', ERROR
		end
		[RUBY_PLATFORM, NONE]
	end

end

class AmritaChecker < InstallChecker

	def check
		begin
			require 'amrita/template'
		rescue LoadError
			return 'Amrita is not installed', ERROR
		end
		
		dist = ''
		begin
			tmpl = Amrita::TemplateText.new('<a href="@r"></a>')
			if tmpl.respond_to?('expand_attr=')
				tmpl.expand_attr = true
			end
			tmpl.expand(dist, {:r => 'a.png'})
		rescue 
		end
		
		return 'Not supported expand attribute.', ERROR if '<a href="a.png"></a>' != dist
		
		nil
	end

end

class RDChecker < InstallChecker

	def check
		begin
			require 'rd/rd2html-lib'
		rescue LoadError
			return 'RDTools is not installed', ERROR
		end
		
		begin
			require 'rd/rd2html-ext-lib'
		rescue LoadError
			return 'rd2html-ext-lib is not installed', WARNING
		end
		
		nil
	end

end

end
