/*
 * $Id: HTMLUtilities.java,v 1.1 2004/03/24 18:00:19 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;


/**
 * 
 */
public class HTMLUtilities {

	final static String[] specialMarks = {
		"&", "&amp;",
		"<", "&lt;",
		">", "&gt;",
		"\"", "&quot;",
	};

	public static String escape(String text){
		for (int i = 0; i < specialMarks.length; i+=2) {
			text = text.replaceAll(specialMarks[i], specialMarks[i+1]);
		}
		return text;
	}
	
	public static String unescape(String text){
		for (int i = specialMarks.length-1; i>=0 ; i-=2) {
			text = text.replaceAll(specialMarks[i], specialMarks[i-1]);
		}
		return text;
	}
	
	
	
	
}
