/*
 * $Id: RubyException.java,v 1.6 2004/04/20 06:56:44 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.*;
import java.util.*;
import java.util.regex.*;

/**
 * 
 */
public class RubyException extends Throwable {

	public static class TraceItem {
		
		final public String script, occasionIn;
		final public int lineNumber;
		
		public TraceItem(String script, int lineNumber, String occasionIn){
			this.script = script;
			this.lineNumber = lineNumber;
			this.occasionIn = occasionIn;
		}
	}

	// (erb):3:in `z': undefined local variable or method `zzz' for main:Object (NameError)
	
	final public static Pattern
		firstLinePattern = Pattern.compile("^([^\t].+?):(\\d+):(.+)$"),
		traceLinePattern = Pattern.compile("^\tfrom (.+?):(\\d+)(?:|:(.+))$");

	public static RubyException[] createFromLines(Iterator lines){
		ArrayList exceptions = new ArrayList();
		
		RubyException ex = null;
		while(lines.hasNext()) {
			String line = lines.next().toString();
			Matcher beginTraceMatch = firstLinePattern.matcher(line);
			if( beginTraceMatch.matches() ){
				if(ex != null){
					exceptions.add(ex);
				}
				ex = new RubyException(beginTraceMatch.group(3).trim());
				ex.addItem(
					beginTraceMatch.group(1).trim(),
					Integer.parseInt(beginTraceMatch.group(2)),
					null);
			}
			if(ex != null){
				Matcher traceMatch = traceLinePattern.matcher(line);
				if(traceMatch.matches()){
					ex.addItem(
						traceMatch.group(1).trim(),
						Integer.parseInt( traceMatch.group(2) ),
						traceMatch.group(3) != null ? traceMatch.group(3).trim() : null);
				}
			}
		}
		if( ex != null){
			exceptions.add(ex);
		}
		
		return (RubyException[])exceptions.toArray(new RubyException[exceptions.size()]);
	}
	
	ArrayList items = new ArrayList();

	public RubyException(String message){
		super(message);
	}

	public void addItem(String script, int lineNumber, String occasionIn){
		addItem( new TraceItem(script, lineNumber, occasionIn) );
	}

	public void addItem(TraceItem item){
		items.add(item);
	}
	
	public TraceItem[] getTraceItems(){
		return (TraceItem[])items.toArray(new TraceItem[items.size()]);
	}

	public void printStackTrace(PrintStream s) {
		printStackTrace(new PrintWriter(s, true));
	}

	public void printStackTrace(PrintWriter s) {
		s.write(toStackTraceString());
	}

	public String toStackTraceString() {
		StringBuffer buff = new StringBuffer();
		TraceItem item = (TraceItem)items.get(0);
		buff.append(item.script + ':' + item.lineNumber + ':' + getMessage() + '\n');
		for(int i=1; i<items.size(); i++){
			item = (TraceItem)items.get(i);
			buff.append("\tfrom " + item.script + ':' + item.lineNumber);
			if( item.occasionIn != null){
				buff.append(':' + item.occasionIn);
			}
			buff.append('\n');
		}
		return buff.toString();
	}
}
