/*
 * $Id: Wildcard.java,v 1.4 2004/04/01 05:48:07 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.util.regex.*;

/**
 * Wildcard
 * "**" is incremental directory match. "?" is one char, * is zero or occurences pattern.
 */
public class Wildcard {

	/**
	 * Inifinity represents search for child node.
	 */
	final static Pattern INFINITY = null;

	String orgPattern;
	Pattern[] matchPatterns;

	public Wildcard(String orgPattern) throws PatternSyntaxException {
		this.orgPattern = orgPattern;
		String[] divPatterns = orgPattern.split("/");
		if( orgPattern.length() > 0 && orgPattern.charAt(orgPattern.length() - 1) == '/'){
			matchPatterns = new Pattern[divPatterns.length+1];
			matchPatterns[ divPatterns.length ] = Pattern.compile("^$");
		}else{
			matchPatterns = new Pattern[divPatterns.length];
		}
		
		for(int i=0; i<divPatterns.length; i++){
			String ptn = divPatterns[i];
			if( ptn.length() == 2 && ptn.indexOf("**") == 0){
				matchPatterns[i] = INFINITY;
			}else{
				String p = ptn
					.replaceAll("\\.", "\\.")
					.replaceAll("\\?", ".")
					.replaceAll("\\*", ".*?");
				
				matchPatterns[i] = Pattern.compile(p);
			}
		}
	}
	
	public boolean match(String path){
		String[] names = path.split("/");
		if(path.charAt(path.length() - 1) == '/'){
			String[] newNames = new String[names.length+1];
			System.arraycopy(names,0, newNames, 0, names.length);
			newNames[names.length] = "";
			names = newNames;
		}
		if(names.length < matchPatterns.length){
			return false;
		}
		for (int i=0, j=0; i<names.length; i++) {
			String n = names[i];
			if( j < matchPatterns.length){
				Pattern ptn = matchPatterns[j++];
				if( ptn == INFINITY){
					i = names.length - (matchPatterns.length - j) - 1;
					if( i < -1){
						return false;
					}
				} else if (!ptn.matcher(n).matches() ){
					return false;
				}
			}else{
				return false;
			}
		}
		return true;
	}

	public String toString() {
		return orgPattern;
	}
	
	public boolean equals(Object obj) {
		return(obj instanceof Wildcard && ((Wildcard)obj).toString().equals(toString()));
	}

}
