/*
 * $Id: FilePreset.java,v 1.1 2004/04/25 00:42:31 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.preset;

import java.io.*;
import java.net.URL;
import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.*;

/**
 * 
 */
public class FilePreset extends Preset {

	final static String[] ignoreFileNames = {
		"CVS",
	};

	static FileFilter filter = new FileFilter() {
		public boolean accept(File pathname) {
			return Arrays.binarySearch(ignoreFileNames, pathname.getName()) < 0;
		}
	};

	File rootDir;
	
	public FilePreset(URL baseDirectory, String name, String description) throws CoreException {
		super(baseDirectory, name, description);
		Exception error = null;
		try {
			rootDir = new File(Platform.asLocalURL(baseDirectory).getFile());
			FileInputStream stream = new FileInputStream(new File(rootDir, ".webproject"));
			try{
				loadProperty(stream);
			}finally{
				stream.close();
			}
		} catch (IOException e) {
			error = e;
		}
		if(getWebProjectProperty() == null){
			error = new IllegalArgumentException("specify directory is not contain .webproject file:" + baseDirectory);
		}
		if( error != null){
			throw new CoreException(new Status(IStatus.ERROR, WebpubPlugin.ID_PLUGIN, IStatus.OK, error.getMessage(), error));
		}
	}
	
	public Map getDistributeFiles(WebProject webProject){
		HashMap targets = new HashMap();
		
		Preferences prop = getWebProjectProperty();
		
		File htSourcesDir = new File(rootDir, prop.getString(WebProject.KEY_HTSOURCES_FOLDER));
		IContainer htSourceFolder = webProject.getFolder(WebProject.KEY_HTSOURCES_FOLDER);
		File[] htSourceFiles = collectFiles(htSourcesDir);
		for(int i=0; i<htSourceFiles.length; i++){
			File f = htSourceFiles[i];
			Path rel = new Path(f.toString().substring(htSourcesDir.toString().length()));
			targets.put(f, f.isDirectory() ? (IResource)htSourceFolder.getFolder(rel) : (IResource)htSourceFolder.getFile(rel));
		}
		
		File scriptsDir = new File(rootDir, prop.getString(WebProject.KEY_SCRIPTS_FOLDER));
		IContainer scriptsFolder = webProject.getFolder(WebProject.KEY_SCRIPTS_FOLDER);
		File[] scriptFiles = collectFiles(scriptsDir);
		for(int i=0; i<scriptFiles.length; i++){
			File f = scriptFiles[i];
			Path rel = new Path(f.toString().substring(scriptsDir.toString().length()));
			targets.put(f, f.isDirectory() ? (IResource)scriptsFolder.getFolder(rel) : (IResource)scriptsFolder.getFile(rel));
		}
		
		File[] files = collectFiles(rootDir);
		for (int j=0; j<files.length; j++) {
			File f = files[j];
			if(!targets.containsKey(f)){
				String path = f.toString().substring(rootDir.toString().length());
				if(path.length() > 0){
					IProject proj = webProject.getProject();
					targets.put(f, f.isDirectory() ? (IResource)proj.getFolder(path) : (IResource)proj.getFile(path));
				}
			}
		}
		
		return targets;
	}
	
	File[] collectFiles(File base){
		ArrayList dist = new ArrayList();
		collectFiles(base, dist);
		return (File[]) dist.toArray(new File[dist.size()]);
	}
	
	void collectFiles(File file, List dist){
		dist.add(file);
		if(file.isDirectory()){
			File[] files = file.listFiles(filter);
			for (int i = 0; i < files.length; i++) {
				collectFiles( files[i], dist);
			}
		}
	}

	protected void distribute(WebProject webProject, IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("distribute preset files", 10000);
		try{
			Map distTargets = getDistributeFiles(webProject);
			if(distTargets.isEmpty()){
				return;
			}
			File[] files = (File[])distTargets.keySet().toArray(new File[distTargets.size()]);
			Arrays.sort(files);
			
			int ratio = 10000 / files.length;
			for (int i=0; i<files.length; i++) {
				File f = files[i];
				if(f.isDirectory()){
					createFolder((IFolder)distTargets.get(f), new SubProgressMonitor(monitor, ratio));
				}else{
					File to = ((IFile)distTargets.get(f)).getLocation().toFile();
					FileUtilities.copy(f, to);
					monitor.worked(ratio);
				}
			}
		} catch (IOException e) {
			throw new CoreException(new Status(
					IStatus.ERROR,
					WebpubPlugin.ID_PLUGIN,
					IStatus.OK,
					"appearance error in file coping: " + baseDirectory,
					e));
		}finally{
			monitor.done();
		}
	}
	
	
}
