/*
 * $Id: PublishDescription.java,v 1.3 2004/04/01 05:48:09 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.util.*;

import org.eclipse.core.resources.IResource;

public class PublishDescription {

	final String publishBy;
	IResource publishTo = null;
	HashMap arguments = new HashMap();

	public PublishDescription(String publishBy) {
		this.publishBy = publishBy;
	}

	public String getPublishBy() {
		return publishBy;
	}

	/**
	 * Sets publish location.
	 * Location must be IFolder or IFile. (that is not only file
	 * exist or none exist.)
	 */
	public void setPublishTo(IResource to) {
		this.publishTo = to;
	}
	
	public String[] getArgumentKeys(){
		return (String[])arguments.keySet().toArray(new String[arguments.size()]);
	}

	/**
	 * Returns publish location.
	 */
	public IResource getPublishTo() {
		return publishTo;
	}

	/**
	 * Sets argument for publish. if value specify null, remove this argument entry.
	 */
	public void setArgument(String key, String value){
		if( value == null){
			arguments.remove(key);
		}else{
			arguments.put(key, value);
		}
	}
	
	/**
	 * Returns argument key/values each keys and values type is a String.
	 */
	public Map getArguments(){
		return (Map)arguments.clone();
	}
	
	/**
	 * Returns argument for publish.
	 */
	public String getArgument(String key){
		return (String)arguments.get(key);
	}
	
	public boolean equals(Object obj) {
		if( !(obj instanceof PublishDescription)){
			return false;
		}
		PublishDescription other = (PublishDescription)obj;
		
		return
			argumentsEquals(other) &&
			publishTo != null ?
				publishTo.equals( other.publishTo) :
				null == other.publishTo;
	}

	/**
	 * Return true if publish content (Publishing tool id, and that argument
	 * without publish location differer).
	 */
	public boolean argumentsEquals(PublishDescription other){
		return
			publishBy.equals(other.publishBy) &&
			arguments.equals(other.arguments);
	}
	
	public String toString() {
		return "by=" + publishBy + ",publish_to=" + publishTo + ",arguments=" + arguments;
	}
	
}
