/*
 * $Id: PublishDescriptionDefinition.java,v 1.4 2004/04/01 05:48:08 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.*;
import java.util.*;

import javax.xml.parsers.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

import com.narucy.webpub.core.Wildcard;

/**
 * 
 */
public class PublishDescriptionDefinition {

	static DocumentBuilderFactory docBuilderFac = DocumentBuilderFactory.newInstance();

	IFile propFile;
	Map[] mappings;

	public PublishDescriptionDefinition(IFile propFile) throws IllegalConfigurationException{
		this.propFile = propFile;
		ArrayList maps = new ArrayList();
		
		InputStream stream = null;
		Exception error = null;
		try {
			stream = propFile.getContents();
			Document doc = docBuilderFac.newDocumentBuilder().parse(stream);
			Element rootElem = doc.getDocumentElement();
			NodeList mappingNodes = rootElem.getElementsByTagName("mapping");
			
			for(int i=0; i<mappingNodes.getLength(); i++){
				Element elem = (Element)mappingNodes.item(i);
				Wildcard wildcard = new Wildcard(elem.getAttribute("pattern"));
				NamedNodeMap entry = elem.getElementsByTagName("publish").item(0).getAttributes();

				Map m = new HashMap();
				m.put("pattern", wildcard);
				for(int j=0; j<entry.getLength(); j++){
					Node n = entry.item(j);
					m.put(n.getNodeName(), n.getNodeValue());
				}
				if(!m.containsKey("by")){
					throw new IllegalConfigurationException("publish entry must be specify by attribute: " + propFile);
				}
				maps.add(m);
			}
		} catch (SAXException e) {
			error = e;
		} catch (IOException e) {
			error = e;
		} catch (ParserConfigurationException e) {
			error = e;
		} catch(CoreException e){
			error = e;
		} finally{
			if(stream != null){
				try {
					stream.close();
				} catch (IOException e) {
					error = e;
				}
			}
			if( error != null){
				throw new IllegalConfigurationException(error);
			}
		}
		this.mappings = (Map[]) maps.toArray(new Map[maps.size()]);
	}
	
	public int getMatchIndex(IResource source){
		String relativePath =
				source.getFullPath().
				removeFirstSegments(propFile.getParent().getFullPath().segmentCount() ).toString();

		if(relativePath.length() > 0){
			for (int i=0; i<getEntryCount(); i++) {
				Wildcard pattern = getPattern(i);
				if(pattern.match(relativePath)){
					return i;
				}
			}
		}
		return -1;
	}

	public IFile getPropertyFile(){
		return propFile;
	}
	
	public Wildcard getPattern(int index){
		return (Wildcard)mappings[index].get("pattern");
	}
	
	public int getEntryCount(){
		return mappings.length;
	}
	
	public String getPublishBy(int index){
		return (String)mappings[index].get("by");
	}
	
	public Map getArguments(int index){
		Map args = new HashMap();
		Object[] keys = mappings[index].keySet().toArray();
		for (int i = 0; i < keys.length; i++) {
			String k = (String)keys[i];
			if(!k.equals("pattern") && !k.equals("by") ){
				args.put(k, mappings[index].get(k));
			}
		}
		return args;
	}

}
