/*
 * $Id: PublishResultReader.java,v 1.5 2004/04/12 12:10:40 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.*;
import java.util.*;

import com.narucy.webpub.core.*;

public class PublishResultReader extends Thread {

	boolean done = false;

	HashMap
		oks = new HashMap(),
		faileds = new HashMap();
	
	TextReader reader;
	PrintWriter unparsedLineOut;

	public PublishResultReader(InputStream stream, String encoding, File unparsedLineOuputFile) throws IOException {
		reader = new TextReader(stream, encoding);
		unparsedLineOut = new PrintWriter(new OutputStreamWriter(new FileOutputStream(unparsedLineOuputFile), encoding));
	}

	public void run() {
		try {
			String[] errorEntry = null;
			ArrayList errorLines = new ArrayList();
			while (reader.hasNext()) {
				String line = reader.nextLine();
				if ( line.equals(">>>") && errorEntry != null) {
					faileds.put(
							errorEntry[1],
							new Object[]{
									errorEntry[2],
									errorEntry[3],
									errorLines.toArray(new String[errorLines.size()]),
							});
					
					errorEntry = null;
					errorLines.clear();
					continue;
				}
				if (errorEntry != null) {
					errorLines.add(line);
					continue;
				}
				if (isConsoleCode(line, "FAILED") ) {
					String[] entry = line.split(",");
					if (entry.length == 4) {
						errorEntry = entry;
						continue;
					}
				}
				if (isConsoleCode(line, "OK")) {
					String[] entry = line.split(",");
					if (entry.length == 5) {
						oks.put( entry[1], new String[]{entry[2], entry[3]});
						continue;
					}
				}
				unparsedLineOut.println(line);
			}
		} finally {
			reader.close();
			unparsedLineOut.close();
			done = true;
		}
	}
	
	Object[] getEntry(String file){
		Object[] entry = (Object[])oks.get(file);
		if(entry == null){
			entry = (Object[])faileds.get(file);
		}
		return entry;
	}
	
	public String getPublishTo(String file){
		Object[] entry = getEntry(file);
		return (entry != null) ? (String)entry[1] : null;
	}
	
	public String getPublishBy(String file){
		Object[] entry = getEntry(file);
		return (entry != null) ? (String)entry[0] : null;
	}

	public RubyException[] getRubyException(String file){
		if( faileds.containsKey(file) ){
			Object errEntry = ((Object[])faileds.get(file))[2];
			
			RubyException[] exceptions;
			if(errEntry instanceof RubyException[]){
				exceptions = (RubyException[])errEntry;
			}else{
				String[] lines = (String[])errEntry;
				exceptions = RubyException.createFromLines( Arrays.asList(lines).iterator() );
				((Object[])faileds.get(file))[2] = exceptions;
			}
			return (RubyException[])exceptions.clone();
		}
		return null;
	}
	
	public String[] getErrorFiles(){
		return (String[])faileds.keySet().toArray(new String[faileds.size()]);
	}
	
	public String[] getOKFiles(){
		return (String[])oks.keySet().toArray(new String[oks.size()]);
	}
	
	public int getFinishedCount(){
		return faileds.size() + oks.size();
	}
	
	static boolean isConsoleCode(String line, String code) {
		for(int i=0; i<3; i++){
			if(line.charAt(i) != '<'){
				return false;
			}
		}
		for(int i=0, len=code.length(); i<len; i++){
			if(line.charAt(i+3) != code.charAt(i)){
				return false;
			}
		}
		return true;
	}

	public boolean isDone() {
		return done;
	}

}